/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArrayUtil;
import numpy.core.ScalarUtil;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.Header;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Value;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.MultiLabel;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.visitors.AbstractExtender;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasEstimatorEnsemble;
import sklearn.Initializer;
import sklearn.ScalarLabelUtil;
import sklearn.Step;
import sklearn.Transformer;
import sklearn.pipeline.FeatureUnion;
import sklearn.pipeline.Pipeline;
import sklearn.pipeline.PipelineClassifier;
import sklearn.pipeline.PipelineRegressor;
import sklearn.pipeline.PipelineTransformer;
import sklearn2pmml.decoration.Domain;
import sklearn2pmml.pipeline.Verification;

public class PMMLPipeline
extends Pipeline {
    private static final Logger logger = LoggerFactory.getLogger(PMMLPipeline.class);

    public PMMLPipeline() {
        this("sklearn2pmml", "PMMLPipeline");
    }

    public PMMLPipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        logger.warn(ClassDictUtil.formatClass((Object)this) + " should be replaced with " + ClassDictUtil.formatClass((Object)new Pipeline()) + " in nested workflows");
        return super.encodeFeatures(features, encoder);
    }

    public PMML encodePMML(SkLearnEncoder encoder) {
        List<? extends Number> featureImportances;
        List<? extends Transformer> transformers = this.getTransformers();
        Estimator estimator = null;
        if (this.hasFinalEstimator()) {
            estimator = this.getFinalEstimator();
        }
        Map<?, ?> header = this.getHeader();
        Transformer predictTransformer = this.getPredictTransformer();
        Transformer predictProbaTransformer = this.getPredictProbaTransformer();
        Transformer applyTransformer = this.getApplyTransformer();
        List<String> activeFields = this.getActiveFields();
        List<String> probabilityFields = null;
        List<String> targetFields = this.getTargetFields();
        String repr = this.getRepr();
        Verification verification = this.getVerification();
        Label label = null;
        if (estimator != null && estimator.isSupervised()) {
            if (targetFields == null) {
                targetFields = this.initTargetFields(estimator);
            }
            label = PMMLPipeline.initLabel(estimator, targetFields, encoder);
        }
        List<Feature> features = new ArrayList<Feature>();
        Step featureInitializer = estimator;
        try {
            Transformer transformer = PMMLPipeline.getHead(transformers, estimator);
            if (transformer != null) {
                featureInitializer = transformer;
                if (!(transformer instanceof Initializer)) {
                    if (activeFields == null) {
                        activeFields = this.initActiveFields(transformer);
                    }
                    features = PMMLPipeline.initFeatures(transformer, activeFields, transformer.getOpType(), transformer.getDataType(), encoder);
                }
                features = super.encodeFeatures(features, encoder);
            } else if (estimator != null) {
                if (activeFields == null) {
                    activeFields = this.initActiveFields(estimator);
                }
                features = PMMLPipeline.initFeatures(estimator, activeFields, estimator.getOpType(), estimator.getDataType(), encoder);
            }
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("The transformer object of the first step (" + ClassDictUtil.formatClass((Object)featureInitializer) + ") does not specify feature type information", uoe);
        }
        if (estimator == null) {
            return this.encodePMML(header, null, repr, encoder);
        }
        Schema schema = new Schema((PMMLEncoder)encoder, label, features);
        Model model = estimator.encode(schema);
        encoder.setModel(model);
        if (!estimator.hasFeatureImportances() && (featureImportances = this.getPMMLFeatureImportances()) != null) {
            ClassDictUtil.checkSize((Collection[])new Collection[]{activeFields, featureImportances});
            for (int i = 0; i < activeFields.size(); ++i) {
                String activeField = activeFields.get(i);
                Number featureImportance = featureImportances.get(i);
                DataField dataField = encoder.getDataField(activeField);
                if (dataField == null) {
                    throw new IllegalArgumentException("Field " + activeField + " is undefined");
                }
                WildcardFeature feature = new WildcardFeature((PMMLEncoder)encoder, dataField);
                encoder.addFeatureImportance(model, (Feature)feature, featureImportance);
            }
        }
        if (predictTransformer != null || predictProbaTransformer != null || applyTransformer != null) {
            Model finalModel = MiningModelUtil.getFinalModel((Model)model);
            encoder.setModel(finalModel);
            Output output = ModelUtil.ensureOutput((Model)finalModel);
            if (predictTransformer != null) {
                List<ScalarLabel> scalarLabels = PMMLPipeline.toScalarLabels(label);
                ArrayList<OutputField> predictFields = new ArrayList<OutputField>();
                for (ScalarLabel scalarLabel : scalarLabels) {
                    OutputField predictField = ModelUtil.createPredictedField((String)FieldNameUtil.create((String)"predict", (Object[])new Object[]{scalarLabel.getName()}), (OpType)ScalarLabelUtil.getOpType(scalarLabel), (DataType)scalarLabel.getDataType()).setFinalResult(Boolean.valueOf(false));
                    output.addOutputFields(new OutputField[]{predictField});
                    predictFields.add(predictField);
                }
                this.encodeOutput(output, predictFields, predictTransformer, encoder);
            }
            if (predictProbaTransformer != null) {
                CategoricalLabel categoricalLabel = (CategoricalLabel)label;
                List predictProbaFields = ModelUtil.createProbabilityFields((DataType)DataType.DOUBLE, (List)categoricalLabel.getValues());
                this.encodeOutput(output, predictProbaFields, predictProbaTransformer, encoder);
            }
            if (applyTransformer != null) {
                OutputField nodeIdField = ModelUtil.createEntityIdField((String)"nodeId", (DataType)DataType.INTEGER);
                this.encodeOutput(output, Collections.singletonList(nodeIdField), applyTransformer, encoder);
            }
            encoder.setModel(model);
        }
        if (estimator.isSupervised()) {
            if (verification == null) {
                logger.warn("Model verification data is not set. Use method '" + ClassDictUtil.formatMember((ClassDict)this, (String)"verify(X)") + "' to correct this deficiency");
            } else {
                List<?> activeValues = verification.getActiveValues();
                int[] activeValuesShape = verification.getActiveValuesShape();
                ClassDictUtil.checkShapes((int)1, (int)activeFields.size(), (int[][])new int[][]{activeValuesShape});
                int rows = activeValuesShape[0];
                LinkedHashMap<VerificationField, List> data = new LinkedHashMap<VerificationField, List>();
                if (activeFields != null) {
                    for (int i = 0; i < activeFields.size(); ++i) {
                        VerificationField verificationField = ModelUtil.createVerificationField((String)activeFields.get(i));
                        Domain domain = encoder.getDomain(verificationField.requireField());
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(domain, activeValues), (int)rows, (int)activeFields.size(), (int)i));
                    }
                }
                Number precision = verification.getPrecision();
                Number zeroThreshold = verification.getZeroThreshold();
                List<ScalarLabel> scalarLabels = PMMLPipeline.toScalarLabels(label);
                boolean hasProbabilityValues = verification.hasProbabilityValues();
                if (estimator instanceof Classifier) {
                    Classifier classifier = (Classifier)estimator;
                    hasProbabilityValues &= classifier.hasProbabilityDistribution();
                } else {
                    hasProbabilityValues = false;
                }
                if (hasProbabilityValues) {
                    List<? extends Number> probabilityValues = verification.getProbabilityValues();
                    int[] probabilityValuesShape = verification.getProbabilityValuesShape();
                    ClassDictUtil.checkShapes((int)0, (int[][])new int[][]{activeValuesShape, probabilityValuesShape});
                    ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{scalarLabels});
                    ScalarLabel scalarLabel = scalarLabels.get(0);
                    probabilityFields = this.initProbabilityFields((CategoricalLabel)scalarLabel);
                    ClassDictUtil.checkShapes((int)1, (int)probabilityFields.size(), (int[][])new int[][]{probabilityValuesShape});
                    for (int i = 0; i < probabilityFields.size(); ++i) {
                        VerificationField verificationField = ModelUtil.createVerificationField((String)probabilityFields.get(i)).setPrecision(precision).setZeroThreshold(zeroThreshold);
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(null, probabilityValues), (int)rows, (int)probabilityFields.size(), (int)i));
                    }
                } else {
                    List<?> targetValues = verification.getTargetValues();
                    int[] targetValuesShape = verification.getTargetValuesShape();
                    ClassDictUtil.checkShapes((int)0, (int[][])new int[][]{activeValuesShape, targetValuesShape});
                    ClassDictUtil.checkSize((Collection[])new Collection[]{targetFields, scalarLabels});
                    for (int i = 0; i < targetFields.size(); ++i) {
                        VerificationField verificationField = ModelUtil.createVerificationField((String)targetFields.get(i));
                        ScalarLabel scalarLabel = scalarLabels.get(i);
                        DataType dataType = scalarLabel.getDataType();
                        switch (dataType) {
                            case DOUBLE: 
                            case FLOAT: {
                                verificationField.setPrecision(precision).setZeroThreshold(zeroThreshold);
                                break;
                            }
                        }
                        Domain domain = encoder.getDomain(verificationField.requireField());
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(domain, targetValues), (int)rows, (int)targetFields.size(), (int)i));
                    }
                }
                model.setModelVerification(ModelUtil.createModelVerification(data));
            }
        }
        return this.encodePMML(header, model, repr, encoder);
    }

    private PMML encodePMML(Map<?, ?> header, Model model, String repr, SkLearnEncoder encoder) {
        PMML pmml = encoder.encodePMML(model);
        if (header != null) {
            Header pmmlHeader = pmml.requireHeader();
            pmmlHeader.setCopyright((String)header.get("copyright"));
            pmmlHeader.setDescription((String)header.get("description"));
            pmmlHeader.setModelVersion((String)header.get("modelVersion"));
        }
        if (repr != null) {
            MiningBuildTask miningBuildTask = new MiningBuildTask().addExtensions(new Extension[]{PMMLUtil.createExtension((String)"repr", (Object[])new Object[]{repr})});
            pmml.setMiningBuildTask(miningBuildTask);
        }
        return pmml;
    }

    private void encodeOutput(Output output, List<OutputField> outputFields, Transformer transformer, SkLearnEncoder encoder) {
        SkLearnEncoder outputEncoder = new SkLearnEncoder();
        Model model = encoder.getModel();
        if (model != null) {
            outputEncoder.setModel(model);
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (OutputField outputField : outputFields) {
            DataField dataField = outputEncoder.createDataField(outputField.requireName(), outputField.requireOpType(), outputField.requireDataType());
            features.add((Feature)new WildcardFeature((PMMLEncoder)outputEncoder, dataField));
        }
        transformer.encode(features, outputEncoder);
        Collection derivedFields = outputEncoder.getDerivedFields().values();
        Iterator it = derivedFields.iterator();
        while (it.hasNext()) {
            OutputField outputField;
            DerivedField derivedField = (DerivedField)it.next();
            if (derivedField instanceof DerivedOutputField) {
                DerivedOutputField derivedOutputField = (DerivedOutputField)derivedField;
                outputField = derivedOutputField.getOutputField();
            } else {
                outputField = new OutputField(derivedField.requireName(), derivedField.requireOpType(), derivedField.requireDataType()).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(!it.hasNext())).setExpression(derivedField.requireExpression());
            }
            output.addOutputFields(new OutputField[]{outputField});
        }
        Map defineFunctions = outputEncoder.getDefineFunctions();
        for (DefineFunction defineFunction : defineFunctions.values()) {
            encoder.addDefineFunction(defineFunction);
        }
    }

    @Override
    public List<Object[]> getSteps() {
        return super.getSteps();
    }

    public PMMLPipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }

    public Map<?, ?> getHeader() {
        return (Map)this.getOptional("header", Map.class);
    }

    public List<? extends Number> getPMMLFeatureImportances() {
        if (!this.containsKey("pmml_feature_importances_")) {
            return null;
        }
        return this.getNumberArray("pmml_feature_importances_");
    }

    public Transformer getPredictTransformer() {
        return this.getTransformer("predict_transformer");
    }

    public Transformer getPredictProbaTransformer() {
        return this.getTransformer("predict_proba_transformer");
    }

    public Transformer getApplyTransformer() {
        return this.getTransformer("apply_transformer");
    }

    private Transformer getTransformer(String key) {
        return (Transformer)this.getOptional(key, Transformer.class);
    }

    public List<String> getActiveFields() {
        if (!this.containsKey("active_fields")) {
            return null;
        }
        return this.getListLike("active_fields", String.class);
    }

    public PMMLPipeline setActiveFields(List<String> activeFields) {
        this.put("active_fields", NDArrayUtil.toArray(activeFields));
        return this;
    }

    public List<String> getTargetFields() {
        if (this.containsKey("target_field")) {
            return Collections.singletonList(this.getOptionalString("target_field"));
        }
        if (!this.containsKey("target_fields")) {
            return null;
        }
        return this.getListLike("target_fields", String.class);
    }

    public PMMLPipeline setTargetFields(List<String> targetFields) {
        this.put("target_fields", NDArrayUtil.toArray(targetFields));
        return this;
    }

    public String getRepr() {
        return this.getOptionalString("repr_");
    }

    public PMMLPipeline setRepr(String repr) {
        this.put("repr_", repr);
        return this;
    }

    public Verification getVerification() {
        return (Verification)((Object)this.getOptional("verification", Verification.class));
    }

    public PMMLPipeline setVerification(Verification verification) {
        this.put("verification", (Object)verification);
        return this;
    }

    private List<String> initActiveFields(Step step) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures == -1) {
            throw new IllegalArgumentException("The transformer object of the first step (" + ClassDictUtil.formatClass((Object)step) + ") does not specify the number of input features");
        }
        List<String> activeFields = PMMLPipeline.makeVariables("x", numberOfFeatures, true);
        logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"active_fields") + "' is not set. Assuming {} as the names of active fields", activeFields);
        return activeFields;
    }

    private List<String> initProbabilityFields(CategoricalLabel categoricalLabel) {
        ArrayList<String> probabilityFields = new ArrayList<String>();
        List values = categoricalLabel.getValues();
        for (Object value : values) {
            probabilityFields.add("probability(" + value + ")");
        }
        return probabilityFields;
    }

    private List<String> initTargetFields(Estimator estimator) {
        int numberOfOutputs = estimator.getNumberOfOutputs();
        if (numberOfOutputs == -1) {
            logger.warn("The estimator object of the final step (" + ClassDictUtil.formatClass((Object)estimator) + ") does not specify the number of outputs. Assuming a single output");
            numberOfOutputs = 1;
        }
        List<String> targetFields = PMMLPipeline.makeVariables("y", numberOfOutputs, false);
        logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"target_fields") + "' is not set. Assuming {} as the name of target fields", targetFields);
        return targetFields;
    }

    private static Label initLabel(Estimator estimator, List<String> targetFields, SkLearnEncoder encoder) {
        ArrayList<Object> labels = new ArrayList<Object>();
        MiningFunction miningFunction = estimator.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                List categories = EstimatorUtil.getClasses(estimator);
                Map classExtensions = (Map)estimator.getOption("class_extensions", null);
                if (classExtensions != null) {
                    ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{targetFields});
                }
                for (int i = 0; i < targetFields.size(); ++i) {
                    String targetField = targetFields.get(i);
                    labels.add(PMMLPipeline.initCategoricalLabel(targetField, targetFields.size() > 1 ? (List)categories.get(i) : categories, classExtensions, encoder));
                }
                break;
            }
            case REGRESSION: {
                for (int i = 0; i < targetFields.size(); ++i) {
                    String targetField = targetFields.get(i);
                    labels.add(PMMLPipeline.initContinuousLabel(targetField, encoder));
                }
                break;
            }
            case MIXED: {
                HasEstimatorEnsemble hasEstimatorEnsemble = (HasEstimatorEnsemble)((Object)estimator);
                List estimators = hasEstimatorEnsemble.getEstimators();
                ClassDictUtil.checkSize((Collection[])new Collection[]{targetFields, estimators});
                for (int i = 0; i < targetFields.size(); ++i) {
                    String targetField = targetFields.get(i);
                    labels.add((ScalarLabel)PMMLPipeline.initLabel((Estimator)estimators.get(i), Collections.singletonList(targetField), encoder));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (labels.size() == 1) {
            return (Label)labels.get(0);
        }
        if (labels.size() >= 2) {
            return new MultiLabel(labels);
        }
        throw new IllegalArgumentException();
    }

    private static CategoricalLabel initCategoricalLabel(String targetField, List<?> categories, Map<String, Map<String, ?>> classExtensions, SkLearnEncoder encoder) {
        DataType dataType = TypeUtil.getDataType(categories, (DataType)DataType.STRING);
        DataField dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, dataType, categories);
        ArrayList<1> visitors = new ArrayList<1>();
        if (classExtensions != null) {
            Set<Map.Entry<String, Map<String, ?>>> entries = classExtensions.entrySet();
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                final Map values = (Map)entry.getValue();
                AbstractExtender valueExtender = new AbstractExtender(name){

                    public VisitorAction visit(Value pmmlValue) {
                        Object value = values.get(pmmlValue.requireValue());
                        if (value != null) {
                            value = ScalarUtil.decode(value);
                            this.addExtension((PMMLObject)pmmlValue, ValueUtil.asString(value));
                        }
                        return super.visit(pmmlValue);
                    }
                };
                visitors.add(valueExtender);
            }
        }
        for (Visitor visitor : visitors) {
            visitor.applyTo((Visitable)dataField);
        }
        return new CategoricalLabel((Field)dataField);
    }

    private static ContinuousLabel initContinuousLabel(String targetField, SkLearnEncoder encoder) {
        DataField dataField = encoder.createDataField(targetField, OpType.CONTINUOUS, DataType.DOUBLE);
        return new ContinuousLabel((Field)dataField);
    }

    private static List<Feature> initFeatures(Step step, List<String> activeFields, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String activeField : activeFields) {
            DataField dataField = encoder.createDataField(activeField, opType, dataType);
            result.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
        }
        return result;
    }

    private static Transformer getHead(List<? extends Transformer> transformers, Estimator estimator) {
        if (!transformers.isEmpty()) {
            Transformer transformer = transformers.get(0);
            if (transformer instanceof FeatureUnion) {
                FeatureUnion featureUnion = (FeatureUnion)transformer;
                return PMMLPipeline.getHead(featureUnion.getTransformers(), null);
            }
            if (transformer instanceof PipelineTransformer) {
                PipelineTransformer pipelineTransformer = (PipelineTransformer)transformer;
                Pipeline pipeline = pipelineTransformer.getPipeline();
                return PMMLPipeline.getHead(pipeline.getTransformers(), null);
            }
            return transformer;
        }
        if (estimator != null) {
            if (estimator instanceof PipelineClassifier) {
                PipelineClassifier pipelineClassifier = (PipelineClassifier)estimator;
                Pipeline pipeline = pipelineClassifier.getPipeline();
                return PMMLPipeline.getHead(pipeline.getTransformers(), pipeline.getFinalEstimator());
            }
            if (estimator instanceof PipelineRegressor) {
                PipelineRegressor pipelineRegressor = (PipelineRegressor)estimator;
                Pipeline pipeline = pipelineRegressor.getPipeline();
                return PMMLPipeline.getHead(pipeline.getTransformers(), pipeline.getFinalEstimator());
            }
            return null;
        }
        return null;
    }

    private static List<?> cleanValues(Domain domain, List<?> values) {
        Function<Object, Object> function = new Function<Object, Object>(){

            public Object apply(Object value) {
                Domain.checkValue(value);
                if (ValueUtil.isNaN((Object)value)) {
                    return null;
                }
                return value;
            }
        };
        return Lists.transform(values, (Function)function);
    }

    private static List<String> makeVariables(String name, int count, boolean indexed) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        if (count == 1) {
            return Collections.singletonList(name + (indexed ? "1" : ""));
        }
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(name + String.valueOf(i + 1));
        }
        return result;
    }

    private static List<ScalarLabel> toScalarLabels(Label label) {
        if (label instanceof ScalarLabel) {
            ScalarLabel scalarLabel = (ScalarLabel)label;
            return Collections.singletonList(scalarLabel);
        }
        if (label instanceof MultiLabel) {
            MultiLabel multiLabel = (MultiLabel)label;
            List labels = multiLabel.getLabels();
            return labels.stream().map(ScalarLabel.class::cast).collect(Collectors.toList());
        }
        throw new IllegalArgumentException();
    }
}

