/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.python.TupleUtil;
import sklearn.Classifier;
import sklearn2pmml.ensemble.SelectFirstUtil;

public class SelectFirstClassifier
extends Classifier {
    public SelectFirstClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public List<?> getClasses() {
        List<? extends Classifier> classifiers = this.getClassifiers();
        List<?> result = null;
        for (Classifier classifier : classifiers) {
            if (result == null) {
                result = classifier.getClasses();
                continue;
            }
            if (Objects.equals(result, classifier.getClasses())) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    @Override
    public boolean hasProbabilityDistribution() {
        List<? extends Classifier> classifiers = this.getClassifiers();
        boolean result = true;
        for (Classifier classifier : classifiers) {
            result &= classifier.hasProbabilityDistribution();
        }
        return result;
    }

    public MiningModel encodeModel(Schema schema) {
        List<Object[]> steps = this.getSteps();
        return SelectFirstUtil.encodeClassifier(steps, schema);
    }

    public List<? extends Classifier> getClassifiers() {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return TupleUtil.extractElementList(steps, (int)1, Classifier.class);
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }
}

