/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class CutTransformer
extends Transformer {
    public CutTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        List<? extends Number> bins = this.getBins();
        List<?> labels = this.getLabels();
        Boolean right = this.getRight();
        Boolean includeLowest = this.getIncludeLowest();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        if (labels != null) {
            ClassDictUtil.checkSize((int)(bins.size() - 1), (Collection[])new Collection[]{labels});
            dataType = TypeUtil.getDataType(labels, (DataType)DataType.STRING);
        } else {
            dataType = DataType.INTEGER;
        }
        Feature feature = features.get(0);
        Interval.Closure closure = right != false ? Interval.Closure.OPEN_CLOSED : Interval.Closure.CLOSED_OPEN;
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        ArrayList<Integer> labelCategories = new ArrayList<Integer>();
        Discretize discretize = new Discretize(continuousFeature.getName()).setDataType(dataType);
        for (int i = 0; i < bins.size() - 1; ++i) {
            Number leftMargin = bins.get(i);
            Number rightMargin = bins.get(i + 1);
            Interval interval = new Interval(closure).setLeftMargin((Number)CutTransformer.formatMargin(leftMargin)).setRightMargin((Number)CutTransformer.formatMargin(rightMargin));
            if (i == 0 && includeLowest.booleanValue() && interval.requireClosure() == Interval.Closure.OPEN_CLOSED) {
                interval.setClosure(Interval.Closure.CLOSED_CLOSED);
            }
            Integer label = labels != null ? labels.get(i) : Integer.valueOf(i);
            labelCategories.add(label);
            DiscretizeBin discretizeBin = new DiscretizeBin((Object)label, interval);
            discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("cut", continuousFeature), OpType.CATEGORICAL, dataType, (Expression)discretize);
        Object result = labels != null ? new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, labelCategories) : new IndexFeature((PMMLEncoder)encoder, (Field)derivedField, labelCategories);
        return Collections.singletonList(result);
    }

    public List<? extends Number> getBins() {
        return this.getListLike("bins", Number.class);
    }

    public List<?> getLabels() {
        Object labels = this.getOptionalScalar("labels");
        if (labels == null || Boolean.FALSE.equals(labels)) {
            return null;
        }
        return this.getList("labels");
    }

    public Boolean getRight() {
        return this.getBoolean("right");
    }

    public Boolean getIncludeLowest() {
        return this.getBoolean("include_lowest");
    }

    private static Double formatMargin(Number number) {
        double value = number.doubleValue();
        if (Double.isInfinite(value)) {
            return null;
        }
        return value;
    }
}

