/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ScalarLabel;

public class ScalarLabelUtil {
    private ScalarLabelUtil() {
    }

    public static OpType getOpType(ScalarLabel scalarLabel) {
        if (scalarLabel instanceof CategoricalLabel) {
            CategoricalLabel categoricalLabel = (CategoricalLabel)scalarLabel;
            return OpType.CATEGORICAL;
        }
        if (scalarLabel instanceof ContinuousLabel) {
            ContinuousLabel continuousLabel = (ContinuousLabel)scalarLabel;
            return OpType.CONTINUOUS;
        }
        throw new IllegalArgumentException();
    }

    public static Feature toFeature(ScalarLabel scalarLabel, PMMLEncoder encoder) {
        Field field = encoder.getField(scalarLabel.getName());
        return ScalarLabelUtil.toFeature(scalarLabel, field, encoder);
    }

    public static Feature toFeature(ScalarLabel scalarLabel, Field<?> field, PMMLEncoder encoder) {
        if (scalarLabel instanceof ContinuousLabel) {
            ContinuousLabel continuousLabel = (ContinuousLabel)scalarLabel;
            return new ContinuousFeature(encoder, field);
        }
        if (scalarLabel instanceof CategoricalLabel) {
            CategoricalLabel categoricalLabel = (CategoricalLabel)scalarLabel;
            return new CategoricalFeature(encoder, field, categoricalLabel.getValues());
        }
        throw new IllegalArgumentException();
    }

    public static Feature findLabelFeature(ScalarLabel scalarLabel, List<? extends Feature> features) {
        String name = scalarLabel.getName();
        for (Feature feature : features) {
            if (!Objects.equals(feature.getName(), name)) continue;
            return feature;
        }
        return null;
    }
}

