/*
 * Decompiled with CFR 0.152.
 */
package sklearn.compose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jpmml.converter.Feature;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Drop;
import sklearn.Initializer;
import sklearn.InitializerUtil;
import sklearn.PassThrough;
import sklearn.Transformer;

public class ColumnTransformer
extends Initializer {
    public ColumnTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        return this.encodeFeatures(Collections.emptyList(), encoder);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Object[]> fittedTransformers = this.getFittedTransformers();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Object[] fittedTransformer : fittedTransformers) {
            Transformer transformer = ColumnTransformer.getTransformer(fittedTransformer);
            List<Feature> rowFeatures = ColumnTransformer.getFeatures(fittedTransformer, features, encoder);
            rowFeatures = transformer.encode(rowFeatures, encoder);
            result.addAll(rowFeatures);
        }
        return result;
    }

    public List<Object[]> getFittedTransformers() {
        return this.getTupleList("transformers_");
    }

    private static Transformer getTransformer(Object[] fittedTransformer) {
        Object transformer = TupleUtil.extractElement((Object[])fittedTransformer, (int)1);
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            public Transformer apply(Object object) {
                if ("drop".equals(object)) {
                    return Drop.INSTANCE;
                }
                if ("passthrough".equals(object)) {
                    return PassThrough.INSTANCE;
                }
                return (Transformer)super.apply(object);
            }

            protected String formatMessage(Object object) {
                return "The estimator object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        return (Transformer)castFunction.apply(transformer);
    }

    private static List<Feature> getFeatures(Object[] fittedTransformer, List<Feature> features, SkLearnEncoder encoder) {
        List columns = TupleUtil.extractElement((Object[])fittedTransformer, (int)2);
        if (columns instanceof String || columns instanceof Integer) {
            columns = Collections.singletonList(columns);
        } else if (columns instanceof HasArray) {
            HasArray hasArray = (HasArray)columns;
            columns = hasArray.getArrayContent();
        }
        return InitializerUtil.selectFeatures(columns, features, encoder);
    }
}

