/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;

public class DataFrameConstructor
extends Initializer {
    public DataFrameConstructor(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        List<String> columns = this.getColumns();
        TypeInfo dtype = this.getDType();
        DataType dataType = dtype.getDataType();
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String column : columns) {
            DataField dataField = encoder.createDataField(column, opType, dataType);
            result.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
        }
        return result;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        if (features.isEmpty()) {
            return this.initializeFeatures(encoder);
        }
        List<String> columns = this.getColumns();
        TypeInfo dtype = this.getDType();
        DataType dataType = dtype.getDataType();
        SchemaUtil.checkSize((int)columns.size(), features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            String column = columns.get(i);
            if (feature.getDataType() != dataType) {
                throw new IllegalArgumentException();
            }
            encoder.renameFeature(feature, column);
            result.add(feature);
        }
        return result;
    }

    public List<String> getColumns() {
        return this.getList("columns", String.class);
    }

    public TypeInfo getDType() {
        return this.getDType("dtype", true);
    }
}

