/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDefaultValue;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.ExpressionTranslator;
import org.jpmml.python.Scope;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class ExpressionTransformer
extends Transformer {
    public ExpressionTransformer() {
        this("sklearn2pmml.preprocessing", "ExpressionTransformer");
    }

    public ExpressionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Field field;
        FieldRef fieldRef;
        Feature feature;
        DataType dataType;
        Expression expression;
        DerivedField derivedField;
        String expr = this.getExpr();
        Object mapMissingTo = this.getMapMissingTo();
        Object defaultValue = this.getDefaultValue();
        InvalidValueTreatmentMethod invalidValueTreatment = ExpressionTransformer.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        TypeInfo dtype = this.getDType();
        if (ValueUtil.isNaN((Object)defaultValue)) {
            defaultValue = null;
        }
        if (ValueUtil.isNaN((Object)mapMissingTo)) {
            mapMissingTo = null;
        }
        DataFrameScope scope = new DataFrameScope("X", features, (PMMLEncoder)encoder);
        ExpressionTranslator expressionTranslator = new ExpressionTranslator((Scope)scope);
        if (expr.indexOf(10) > -1) {
            derivedField = expressionTranslator.translateDef(expr);
            expression = derivedField.getExpression();
        } else {
            derivedField = null;
            expression = expressionTranslator.translateExpression(expr);
        }
        if (mapMissingTo != null) {
            HasMapMissingTo hasMapMissingTp = (HasMapMissingTo)expression;
            hasMapMissingTp.setMapMissingTo(mapMissingTo);
        }
        if (defaultValue != null) {
            HasDefaultValue hasDefaultValue = (HasDefaultValue)expression;
            hasDefaultValue.setDefaultValue(defaultValue);
        }
        if (invalidValueTreatment != null) {
            Apply apply = (Apply)expression;
            apply.setInvalidValueTreatment(invalidValueTreatment);
        }
        if (dtype != null) {
            dataType = dtype.getDataType();
        } else {
            dataType = TypeUtil.getDataType((Expression)expression, (FeatureResolver)scope);
            if (dataType == null) {
                dataType = DataType.DOUBLE;
            }
        }
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        if (expression instanceof FieldRef && mapMissingTo == null && (feature = scope.resolveFeature((fieldRef = (FieldRef)expression).getField())) != null && (field = feature.getField()).getOpType() == opType && field.getDataType() == dataType) {
            return Collections.singletonList(feature);
        }
        if (derivedField != null) {
            derivedField.setOpType(opType).setDataType(dataType);
        } else {
            derivedField = encoder.createDerivedField(this.createFieldName("eval", expr), opType, dataType, expression);
        }
        return Collections.singletonList(FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder));
    }

    public Object getDefaultValue() {
        return this.getOptionalScalar("default_value");
    }

    public ExpressionTransformer setDefaultValue(Object defaultValue) {
        this.put("default_value", defaultValue);
        return this;
    }

    public TypeInfo getDType() {
        return super.getOptionalDType("dtype", true);
    }

    public ExpressionTransformer setDType(Object dtype) {
        this.put("dtype", dtype);
        return this;
    }

    public String getExpr() {
        if (this.containsKey("expr_")) {
            return this.getString("expr_");
        }
        return this.getString("expr");
    }

    public ExpressionTransformer setExpr(String expr) {
        this.put("expr", expr);
        return this;
    }

    public String getInvalidValueTreatment() {
        return this.getOptionalString("invalid_value_treatment");
    }

    public ExpressionTransformer setInvalidValueTreatment(String invalidValueTreatment) {
        this.put("invalid_value_treatment", invalidValueTreatment);
        return this;
    }

    public Object getMapMissingTo() {
        return this.getOptionalScalar("map_missing_to");
    }

    public ExpressionTransformer setMapMissingTo(Object mapMissingTo) {
        this.put("map_missing_to", mapMissingTo);
        return this;
    }

    private static InvalidValueTreatmentMethod parseInvalidValueTreatment(String invalidValueTreatment) {
        if (invalidValueTreatment == null) {
            return null;
        }
        switch (invalidValueTreatment) {
            case "return_invalid": {
                return InvalidValueTreatmentMethod.RETURN_INVALID;
            }
            case "as_missing": {
                return InvalidValueTreatmentMethod.AS_MISSING;
            }
        }
        throw new IllegalArgumentException(invalidValueTreatment);
    }
}

