/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml;

import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.Schema;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasClasses;
import sklearn.HasEstimator;

public class EstimatorProxy
extends Estimator
implements HasClasses,
HasEstimator<Estimator> {
    public EstimatorProxy() {
        super("sklearn2pmml", "EstimatorProxy");
    }

    public EstimatorProxy(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        Estimator estimator = this.getEstimator();
        return estimator.getNumberOfFeatures();
    }

    @Override
    public OpType getOpType() {
        Estimator estimator = this.getEstimator();
        return estimator.getOpType();
    }

    @Override
    public DataType getDataType() {
        Estimator estimator = this.getEstimator();
        return estimator.getDataType();
    }

    @Override
    public MiningFunction getMiningFunction() {
        Estimator estimator = this.getEstimator();
        return estimator.getMiningFunction();
    }

    @Override
    public boolean isSupervised() {
        Estimator estimator = this.getEstimator();
        return estimator.isSupervised();
    }

    @Override
    public String getAlgorithmName() {
        Estimator estimator = this.getEstimator();
        return estimator.getAlgorithmName();
    }

    @Override
    public List<?> getClasses() {
        Estimator estimator = this.getEstimator();
        return EstimatorUtil.getClasses(estimator);
    }

    @Override
    public Model encodeModel(Schema schema) {
        Estimator estimator = this.getEstimator();
        return estimator.encodeModel(schema);
    }

    @Override
    public void checkLabel(Label label) {
        Estimator estimator = this.getEstimator();
        estimator.checkLabel(label);
    }

    @Override
    public void checkFeatures(List<? extends Feature> features) {
        Estimator estimator = this.getEstimator();
        estimator.checkFeatures(features);
    }

    @Override
    public Estimator getEstimator() {
        final String name = this.containsKey("estimator_") ? "estimator_" : "estimator";
        Object estimator = this.get(name);
        if (estimator == null) {
            throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)name) + "' has a missing (None/null) value");
        }
        CastFunction<Estimator> castFunction = new CastFunction<Estimator>(Estimator.class){

            protected String formatMessage(Object object) {
                return "Attribute '" + ClassDictUtil.formatMember((ClassDict)EstimatorProxy.this, (String)name) + "' has an unsupported value (" + ClassDictUtil.formatClass((Object)object) + ")";
            }
        };
        return (Estimator)castFunction.apply(estimator);
    }

    public static String formatProxyExample(Estimator estimator) {
        return EstimatorProxy.class.getSimpleName() + "(" + estimator.getPythonName() + "(...))";
    }
}

