/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import numpy.DType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.PythonEncoder;
import sklearn.ScalarLabelUtil;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;
import sklearn.neighbors.BinaryTree;
import sklearn.tree.Tree;
import sklearn2pmml.decoration.Alias;
import sklearn2pmml.decoration.Domain;

public class SkLearnEncoder
extends PythonEncoder {
    private Map<String, Domain> domains = new LinkedHashMap<String, Domain>();
    private Label label = null;
    private List<? extends Feature> features = Collections.emptyList();
    private Model model = null;

    public void addTransformer(Model transformer) {
        if (this.hasModel()) {
            throw new IllegalStateException("Model is already defined");
        }
        super.addTransformer(transformer);
    }

    public List<Feature> export(Model model, String name) {
        return this.export(model, Collections.singletonList(name));
    }

    public List<Feature> export(Model model, List<String> names) {
        Output output = model.getOutput();
        if (output == null) {
            throw new IllegalArgumentException();
        }
        List outputFields = output.getOutputFields();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String name : names) {
            CategoricalFeature feature;
            DerivedOutputField derivedOutputField = null;
            List<OutputField> nameOutputFields = SkLearnEncoder.selectOutputFields(name, outputFields);
            for (OutputField nameOutputField : nameOutputFields) {
                derivedOutputField = this.createDerivedField(model, nameOutputField, true);
            }
            OpType opType = derivedOutputField.getOpType();
            switch (opType) {
                case CATEGORICAL: {
                    feature = new CategoricalFeature((PMMLEncoder)this, (org.dmg.pmml.Field)derivedOutputField);
                    break;
                }
                case CONTINUOUS: {
                    feature = new ContinuousFeature((PMMLEncoder)this, (org.dmg.pmml.Field)derivedOutputField);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            result.add((Feature)feature);
            outputFields.removeAll(nameOutputFields);
        }
        return result;
    }

    public Feature exportPrediction(Model model, ScalarLabel scalarLabel) {
        return this.exportPrediction(model, FieldNameUtil.create((String)"predict", (Object[])new Object[]{scalarLabel.getName()}), scalarLabel);
    }

    public Feature exportPrediction(Model model, String name, ScalarLabel scalarLabel) {
        OutputField outputField = ModelUtil.createPredictedField((String)name, (OpType)ScalarLabelUtil.getOpType(scalarLabel), (DataType)scalarLabel.getDataType()).setFinalResult(Boolean.valueOf(false));
        DerivedOutputField derivedOutputField = this.createDerivedField(model, outputField, false);
        return ScalarLabelUtil.toFeature(scalarLabel, derivedOutputField, (PMMLEncoder)this);
    }

    public Feature exportProbability(Model model, Object value) {
        return this.exportProbability(model, FieldNameUtil.create((String)"probability", (Object[])new Object[]{value}), value);
    }

    public Feature exportProbability(Model model, String name, Object value) {
        OutputField probabilityOutputField = ModelUtil.createProbabilityField((String)name, (DataType)DataType.DOUBLE, (Object)value).setFinalResult(Boolean.valueOf(false));
        DerivedOutputField probabilityField = this.createDerivedField(model, probabilityOutputField, false);
        return new ContinuousFeature((PMMLEncoder)this, (org.dmg.pmml.Field)probabilityField);
    }

    public DataField createDataField(String name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(String name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void addDerivedField(DerivedField derivedField) {
        try {
            super.addDerivedField(derivedField);
        }
        catch (RuntimeException re) {
            String name = derivedField.requireName();
            String message = "Field " + name + " is already defined. Please refactor the pipeline so that it would not contain duplicate field declarations, or use the " + Alias.class.getName() + " wrapper class to override the default name with a custom name (eg. " + Alias.formatAliasExample() + ")";
            throw new IllegalArgumentException(message, re);
        }
    }

    public void renameFeature(Feature feature, String renamedName) {
        String name = feature.getName();
        org.dmg.pmml.Field pmmlField = this.getField(name);
        if (pmmlField instanceof DataField) {
            throw new IllegalArgumentException("User input field " + name + " cannot be renamed");
        }
        DerivedField derivedField = this.removeDerivedField(name);
        try {
            Field nameField = Feature.class.getDeclaredField("name");
            ReflectionUtil.setFieldValue((Field)nameField, (Object)feature, (Object)renamedName);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        derivedField.setName(renamedName);
        this.addDerivedField(derivedField);
    }

    public void renameFeatures(List<Feature> features, List<String> renamedNames) {
        ClassDictUtil.checkSize((int)renamedNames.size(), (Collection[])new Collection[]{features});
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            String renamedName = renamedNames.get(i);
            this.renameFeature(feature, renamedName);
        }
    }

    public Schema createSchema() {
        Label label = this.getLabel();
        List<? extends Feature> features = this.getFeatures();
        if (label instanceof ScalarLabel) {
            ScalarLabel scalarLabel = (ScalarLabel)label;
            Feature labelFeature = ScalarLabelUtil.findLabelFeature(scalarLabel, features);
            if (labelFeature != null) {
                DataField dataField = (DataField)labelFeature.getField();
                OpType opType = dataField.requireOpType();
                switch (opType) {
                    case CONTINUOUS: {
                        label = new ContinuousLabel((org.dmg.pmml.Field)dataField);
                        break;
                    }
                    case CATEGORICAL: {
                        label = new CategoricalLabel((org.dmg.pmml.Field)dataField);
                        break;
                    }
                }
                this.setLabel(label);
                features = new ArrayList<Feature>(features);
                features.remove(labelFeature);
            }
            this.setFeatures(features);
        }
        return new Schema((PMMLEncoder)this, label, features);
    }

    public boolean isFrozen(String name) {
        return this.domains.containsKey(name);
    }

    public Domain getDomain(String name) {
        return this.domains.get(name);
    }

    public void setDomain(String name, Domain domain) {
        if (domain != null) {
            this.domains.put(name, domain);
        } else {
            this.domains.remove(name);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public List<? extends Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<? extends Feature> features) {
        this.features = Objects.requireNonNull(features);
    }

    public boolean hasModel() {
        Model model = this.getModel();
        return model != null;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public static boolean isPrediction(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case PREDICTED_VALUE: 
            case TRANSFORMED_VALUE: 
            case DECISION: {
                return true;
            }
        }
        return false;
    }

    private static List<OutputField> selectOutputFields(String name, List<OutputField> outputFields) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        for (OutputField outputField : outputFields) {
            boolean prediction = SkLearnEncoder.isPrediction(outputField);
            if (prediction) {
                result.add(outputField);
            }
            if (!Objects.equals(name, outputField.requireName())) continue;
            if (prediction) {
                return result;
            }
            return Collections.singletonList(outputField);
        }
        throw new IllegalArgumentException(name);
    }

    static {
        ClassLoader clazzLoader = SkLearnEncoder.class.getClassLoader();
        PickleUtil.init((ClassLoader)clazzLoader, (String)"sklearn2pmml.properties");
        DType.addDefinition(BinaryTree.DTYPE_NODEDATA);
        DType.addDefinition(Tree.DTYPE_TREE);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_OLD);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_NEW);
    }
}

