/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.transformations.OutlierTransformation;
import sklearn.Estimator;
import sklearn.HasDecisionFunctionField;
import sklearn.OutlierDetector;
import sklearn.SkLearnOutlierTransformation;

public class OutlierDetectorUtil {
    private OutlierDetectorUtil() {
    }

    public static <E extends Estimator & HasDecisionFunctionField> Output createPredictedOutput(E estimator) {
        Output output = OutlierDetectorUtil.createPredictedOutput(estimator, ((HasDecisionFunctionField)estimator).getDecisionFunctionField(), new Transformation[0]);
        List outputFields = output.getOutputFields();
        OutputField decisionFunctionOutputField = (OutputField)outputFields.get(0);
        if (!decisionFunctionOutputField.isFinalResult()) {
            decisionFunctionOutputField.setFinalResult(Boolean.valueOf(true));
        }
        return output;
    }

    public static <E extends Estimator> Output createPredictedOutput(final E estimator, String name, Transformation ... transformations) {
        OutlierTransformation outlier = new OutlierTransformation(){

            public String getName(String name) {
                return estimator.createFieldName("outlier", new Object[0]);
            }

            public Expression createExpression(FieldRef fieldRef) {
                Number threshold = ((OutlierDetector)((Object)estimator)).getDecisionFunctionThreshold();
                return PMMLUtil.createApply((String)"lessOrEqual", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)threshold)});
            }
        };
        SkLearnOutlierTransformation sklearnOutlier = new SkLearnOutlierTransformation();
        transformations = (Transformation[])Stream.concat(Arrays.stream(transformations), Stream.of(new Transformation[]{outlier, sklearnOutlier})).toArray(Transformation[]::new);
        return ModelUtil.createPredictedOutput((String)name, (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])transformations);
    }
}

