/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.TypeInfo;
import sklearn.MultiTransformer;
import sklearn.preprocessing.EncoderUtil;

public abstract class BaseEncoder
extends MultiTransformer {
    public BaseEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<List<?>> categories = this.getCategories();
        DataType result = null;
        for (int i = 0; i < categories.size(); ++i) {
            List<Object> featureCategories = categories.get(i);
            featureCategories = featureCategories.stream().filter(value -> value != null && !ValueUtil.isNaN((Object)value)).collect(Collectors.toList());
            DataType dataType = TypeUtil.getDataType(featureCategories, null);
            if (result == null) {
                result = dataType;
                continue;
            }
            if (result == dataType) continue;
            throw new UnsupportedOperationException();
        }
        if (result == null) {
            result = DataType.STRING;
        }
        return result;
    }

    public List<List<?>> getCategories() {
        return EncoderUtil.transformCategories(this.getList("categories_", HasArray.class));
    }

    public TypeInfo getDType() {
        return this.getDType("dtype", false);
    }

    public String getHandleUnknown() {
        return this.getOptionalString("handle_unknown");
    }
}

