/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.Value;

public class DomainUtil {
    private DomainUtil() {
    }

    public static MissingValueTreatmentMethod parseMissingValueTreatment(String missingValueTreatment) {
        if (missingValueTreatment == null) {
            return null;
        }
        switch (missingValueTreatment) {
            case "as_is": {
                return MissingValueTreatmentMethod.AS_IS;
            }
            case "as_mean": {
                return MissingValueTreatmentMethod.AS_MEAN;
            }
            case "as_mode": {
                return MissingValueTreatmentMethod.AS_MODE;
            }
            case "as_median": {
                return MissingValueTreatmentMethod.AS_MEDIAN;
            }
            case "as_value": {
                return MissingValueTreatmentMethod.AS_VALUE;
            }
            case "return_invalid": {
                return MissingValueTreatmentMethod.RETURN_INVALID;
            }
        }
        throw new IllegalArgumentException(missingValueTreatment);
    }

    public static InvalidValueTreatmentMethod parseInvalidValueTreatment(String invalidValueTreatment) {
        if (invalidValueTreatment == null) {
            return null;
        }
        switch (invalidValueTreatment) {
            case "as_is": {
                return InvalidValueTreatmentMethod.AS_IS;
            }
            case "as_missing": {
                return InvalidValueTreatmentMethod.AS_MISSING;
            }
            case "as_value": {
                return InvalidValueTreatmentMethod.AS_VALUE;
            }
            case "return_invalid": {
                return InvalidValueTreatmentMethod.RETURN_INVALID;
            }
        }
        throw new IllegalArgumentException(invalidValueTreatment);
    }

    public static OutlierTreatmentMethod parseOutlierTreatment(String outlierTreatment) {
        if (outlierTreatment == null) {
            return null;
        }
        switch (outlierTreatment) {
            case "as_is": {
                return OutlierTreatmentMethod.AS_IS;
            }
            case "as_missing_values": {
                return OutlierTreatmentMethod.AS_MISSING_VALUES;
            }
            case "as_extreme_values": {
                return OutlierTreatmentMethod.AS_EXTREME_VALUES;
            }
        }
        throw new IllegalArgumentException(outlierTreatment);
    }

    public static <E extends Field<E>> void clearValues(E field, Value.Property property) {
        if (((HasDiscreteDomain)field).hasValues()) {
            List pmmlValues = ((HasDiscreteDomain)field).getValues();
            Iterator it = pmmlValues.iterator();
            while (it.hasNext()) {
                Value pmmlValue = (Value)it.next();
                if (pmmlValue.getProperty() != property) continue;
                it.remove();
            }
        }
    }
}

