/*
 * Decompiled with CFR 0.152.
 */
package sklearn.calibration;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Classifier;
import sklearn.calibration.CalibratedClassifier;

public class CalibratedClassifierCV
extends Classifier {
    public CalibratedClassifierCV(String module, String name) {
        super(module, name);
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<CalibratedClassifier> calibratedClassifiers = this.getCalibratedClassifiers();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (calibratedClassifiers.size() == 1) {
            CalibratedClassifier calibratedClassifier = calibratedClassifiers.get(0);
            return calibratedClassifier.encode(schema);
        }
        if (calibratedClassifiers.size() >= 2) {
            Schema segmentSchema = schema.toAnonymousSchema();
            ArrayList<Model> models = new ArrayList<Model>();
            for (int i = 0; i < calibratedClassifiers.size(); ++i) {
                CalibratedClassifier calibratedClassifier = calibratedClassifiers.get(i);
                Model model = calibratedClassifier.encode(i + 1, segmentSchema);
                models.add(model);
            }
            MiningModel miningModel = new MiningModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, models));
            this.encodePredictProbaOutput((Model)miningModel, DataType.DOUBLE, categoricalLabel);
            return miningModel;
        }
        throw new IllegalArgumentException();
    }

    public List<CalibratedClassifier> getCalibratedClassifiers() {
        return this.getList("calibrated_classifiers_", CalibratedClassifier.class);
    }
}

