/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.jpmml.python.CastFunction;
import org.jpmml.python.CastUtil;
import org.jpmml.python.Castable;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TupleUtil;
import sklearn.Classifier;
import sklearn.Clusterer;
import sklearn.Composite;
import sklearn.Estimator;
import sklearn.HasHead;
import sklearn.HasPMMLOptions;
import sklearn.PassThrough;
import sklearn.Regressor;
import sklearn.Transformer;
import sklearn.pipeline.PipelineClassifier;
import sklearn.pipeline.PipelineClusterer;
import sklearn.pipeline.PipelineRegressor;
import sklearn.pipeline.PipelineTransformer;
import sklearn.pipeline.PipelineUtil;

public class Pipeline
extends Composite
implements Castable,
HasHead,
HasPMMLOptions<Pipeline> {
    public Pipeline() {
        this("sklearn.pipeline", "Pipeline");
    }

    public Pipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean hasTransformers() {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            return false;
        }
        if (steps.size() == 1) {
            return !this.hasFinalEstimator();
        }
        return true;
    }

    @Override
    public boolean hasFinalEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            return false;
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement((Object[])finalStep, (int)1);
        if ("passthrough".equals(estimator)) {
            return true;
        }
        estimator = CastUtil.deepCastTo((Object)estimator, Estimator.class);
        return Estimator.class.isInstance(estimator);
    }

    @Override
    public List<? extends Transformer> getTransformers() {
        List<Object[]> steps = this.getSteps();
        if (this.hasFinalEstimator()) {
            steps = steps.subList(0, steps.size() - 1);
        }
        List transformers = TupleUtil.extractElementList(steps, (int)1);
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            public Transformer apply(Object object) {
                if (object == null || "passthrough".equals(object)) {
                    return PassThrough.INSTANCE;
                }
                return (Transformer)super.apply(object);
            }

            public String formatMessage(Object object) {
                return "The transformer object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        return Lists.transform((List)transformers, (Function)castFunction);
    }

    @Override
    public Estimator getFinalEstimator() {
        return this.getFinalEstimator(Estimator.class);
    }

    public <E extends Estimator> E getFinalEstimator(Class<? extends E> clazz) {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("Expected one or more steps, got zero steps");
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement((Object[])finalStep, (int)1);
        CastFunction castFunction = new CastFunction<E>(clazz){

            public E apply(Object object) {
                if ("passthrough".equals(object)) {
                    return null;
                }
                return (Estimator)super.apply(object);
            }

            public String formatMessage(Object object) {
                return "The transformer object of the final step (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Estimator";
            }
        };
        return (E)((Estimator)castFunction.apply(estimator));
    }

    public Object castTo(Class<?> clazz) {
        if (Transformer.class.equals(clazz)) {
            return this.toTransformer();
        }
        if (Estimator.class.equals(clazz)) {
            return this.toEstimator();
        }
        if (Classifier.class.equals(clazz)) {
            return this.toClassifier();
        }
        if (Regressor.class.equals(clazz)) {
            return this.toRegressor();
        }
        return this;
    }

    @Override
    public Transformer getHead() {
        List<? extends Transformer> transformers = this.getTransformers();
        Estimator estimator = null;
        if (this.hasFinalEstimator()) {
            estimator = this.getFinalEstimator();
        }
        return PipelineUtil.getHead(transformers, estimator);
    }

    @Override
    public Map<String, ?> getPMMLOptions() {
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getPMMLOptions();
        }
        return null;
    }

    @Override
    public Pipeline setPMMLOptions(Map<String, ?> pmmlOptions) {
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            estimator.setPMMLOptions((Map)pmmlOptions);
        }
        return this;
    }

    public Transformer toTransformer() {
        Estimator estimator;
        if (this.hasFinalEstimator() && (estimator = this.getFinalEstimator()) != null) {
            throw new IllegalArgumentException("The pipeline ends with an estimator object");
        }
        return new PipelineTransformer(this);
    }

    public Estimator toEstimator() {
        Estimator estimator = this.getFinalEstimator();
        if (estimator instanceof Classifier) {
            return this.toClassifier();
        }
        if (estimator instanceof Regressor) {
            return this.toRegressor();
        }
        if (estimator instanceof Clusterer) {
            return this.toClusterer();
        }
        throw new IllegalArgumentException();
    }

    public Classifier toClassifier() {
        return new PipelineClassifier(this);
    }

    public Regressor toRegressor() {
        return new PipelineRegressor(this);
    }

    public Clusterer toClusterer() {
        return new PipelineClusterer(this);
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }

    protected Pipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }
}

