/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.Castable;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Classifier;
import sklearn.Clusterer;
import sklearn.CompositeClassifier;
import sklearn.CompositeClusterer;
import sklearn.CompositeRegressor;
import sklearn.CompositeTransformer;
import sklearn.Estimator;
import sklearn.HasFeatureNamesIn;
import sklearn.HasHead;
import sklearn.Regressor;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn.Transformer;

public abstract class Composite
extends Step
implements Castable,
HasFeatureNamesIn,
HasHead {
    public Composite(String module, String name) {
        super(module, name);
    }

    public abstract boolean hasTransformers();

    public abstract List<? extends Transformer> getTransformers();

    public abstract boolean hasFinalEstimator();

    public abstract Estimator getFinalEstimator();

    public abstract <E extends Estimator> E getFinalEstimator(Class<? extends E> var1);

    @Override
    public List<String> getFeatureNamesIn() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getSkLearnFeatureNamesIn();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getSkLearnFeatureNamesIn();
        }
        return null;
    }

    @Override
    public int getNumberOfFeatures() {
        if (this.hasTransformers()) {
            List<? extends Transformer> transformers = this.getTransformers();
            return StepUtil.getNumberOfFeatures(transformers);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getNumberOfFeatures();
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getOpType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getOpType();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getDataType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getDataType();
        }
        throw new UnsupportedOperationException();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        if (!this.hasTransformers()) {
            return features;
        }
        List<? extends Transformer> transformers = this.getTransformers();
        for (Transformer transformer : transformers) {
            features = transformer.encode(features, encoder);
        }
        return features;
    }

    public Model encodeModel(Schema schema) {
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List<Feature> features = schema.getFeatures();
        if (this.hasTransformers()) {
            features = this.encodeFeatures(features, encoder);
            label = this.refreshLabel(label, encoder);
            schema = new Schema((PMMLEncoder)encoder, label, features);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.encode(schema);
        }
        throw new UnsupportedOperationException();
    }

    protected Label refreshLabel(Label label, SkLearnEncoder encoder) {
        return label;
    }

    public Object castTo(Class<?> clazz) {
        if (Transformer.class.equals(clazz)) {
            return this.toTransformer();
        }
        if (Estimator.class.equals(clazz)) {
            return this.toEstimator();
        }
        if (Classifier.class.equals(clazz)) {
            return this.toClassifier();
        }
        if (Regressor.class.equals(clazz)) {
            return this.toRegressor();
        }
        return this;
    }

    public Transformer toTransformer() {
        Estimator estimator;
        if (this.hasFinalEstimator() && (estimator = this.getFinalEstimator()) != null) {
            throw new IllegalArgumentException("The pipeline ends with an estimator object");
        }
        return new CompositeTransformer(this);
    }

    public Estimator toEstimator() {
        Estimator estimator = this.getFinalEstimator();
        if (estimator instanceof Classifier) {
            return this.toClassifier();
        }
        if (estimator instanceof Regressor) {
            return this.toRegressor();
        }
        if (estimator instanceof Clusterer) {
            return this.toClusterer();
        }
        throw new IllegalArgumentException();
    }

    public Classifier toClassifier() {
        return new CompositeClassifier(this);
    }

    public Regressor toRegressor() {
        return new CompositeRegressor(this);
    }

    public Clusterer toClusterer() {
        return new CompositeClusterer(this);
    }
}

