/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.jpmml.converter.Feature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasFeatureNamesIn;
import sklearn.Step;

public class StepUtil {
    private StepUtil() {
    }

    public static List<String> getFeatureNamesIn(Step step) {
        if (step instanceof HasFeatureNamesIn) {
            HasFeatureNamesIn hasFeatureNamesIn = (HasFeatureNamesIn)((Object)step);
            return hasFeatureNamesIn.getFeatureNamesIn();
        }
        return null;
    }

    public static void checkNumberOfFeatures(Step step, List<? extends Feature> features) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures != -1 && numberOfFeatures != features.size()) {
            throw new IllegalArgumentException("Expected " + numberOfFeatures + " feature(s) (" + ClassDictUtil.formatClass((Object)step) + "), got " + features.size() + " feature(s)");
        }
    }

    public static int getNumberOfFeatures(List<? extends Step> steps) {
        Iterator<? extends Step> iterator = steps.iterator();
        if (iterator.hasNext()) {
            Step step = iterator.next();
            return step.getNumberOfFeatures();
        }
        return -1;
    }

    public static List<String> getOrGenerateFeatureNames(Step step) {
        List<String> result = StepUtil.getFeatureNamesIn(step);
        if (result == null) {
            result = StepUtil.generateFeatureNames(step);
        }
        return result;
    }

    public static List<String> generateFeatureNames(Step step) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures == -1) {
            throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember((ClassDict)step, (String)"n_features_in_") + "' is not set");
        }
        return SkLearnEncoder.generateNames("x", numberOfFeatures, true);
    }
}

