/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.hist_gradient_boosting;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.ensemble.hist_gradient_boosting.BinMapper;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;
import sklearn.ensemble.hist_gradient_boosting.TreePredictorUtil;

public class HistGradientBoostingUtil {
    private HistGradientBoostingUtil() {
    }

    public static MiningModel encodeHistGradientBoosting(List<List<TreePredictor>> predictors, BinMapper binMapper, List<? extends Number> baselinePredictions, int column, Schema schema) {
        List<TreePredictor> treePredictors = predictors.stream().map(predictor -> (TreePredictor)((Object)((Object)predictor.get(column)))).collect(Collectors.toList());
        Number baselinePrediction = baselinePredictions.get(column);
        return HistGradientBoostingUtil.encodeHistGradientBoosting(treePredictors, binMapper, baselinePrediction, schema);
    }

    public static MiningModel encodeHistGradientBoosting(List<TreePredictor> treePredictors, BinMapper binMapper, Number baselinePrediction, Schema schema) {
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        PredicateManager predicateManager = new PredicateManager();
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (TreePredictor treePredictor : treePredictors) {
            TreeModel treeModel = TreePredictorUtil.encodeTreeModel(treePredictor, binMapper, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.SUM, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels)).setTargets(ModelUtil.createRescaleTargets(null, (Number)baselinePrediction, (ContinuousLabel)continuousLabel));
        return miningModel;
    }
}

