/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.stacking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;

public class StackingUtil {
    private StackingUtil() {
    }

    public static <E extends Estimator> MiningModel encodeStacking(List<? extends E> estimators, List<String> stackMethods, PredictFunction predictFunction, E finalEstimator, boolean passthrough, Schema schema) {
        ClassDictUtil.checkSize((Collection[])new Collection[]{estimators, stackMethods});
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        ArrayList<Feature> stackFeatures = new ArrayList<Feature>();
        ArrayList<Model> models = new ArrayList<Model>();
        for (int i = 0; i < estimators.size(); ++i) {
            Estimator estimator = (Estimator)estimators.get(i);
            String stackMethod = stackMethods.get(i);
            Model model = estimator.encode(i + 1, schema);
            List<Feature> predictFeatures = predictFunction.apply(i, model, stackMethod, encoder);
            if (predictFeatures != null && !predictFeatures.isEmpty()) {
                stackFeatures.addAll(predictFeatures);
            }
            models.add(model);
        }
        if (passthrough) {
            stackFeatures.addAll(features);
        }
        Schema stackSchema = new Schema((PMMLEncoder)encoder, label, stackFeatures);
        Model finalModel = finalEstimator.encode(stackSchema);
        models.add(finalModel);
        return MiningModelUtil.createModelChain(models, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING);
    }

    public static interface PredictFunction {
        public List<Feature> apply(int var1, Model var2, String var3, SkLearnEncoder var4);
    }
}

