/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_extraction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Initializer;

public class DictVectorizer
extends Initializer {
    public DictVectorizer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        List<String> featureNames = this.getFeatureNames();
        String separator = this.getSeparator();
        Map<String, Integer> vocabulary = this.getVocabulary();
        Feature[] featureArray = new Feature[featureNames.size()];
        Iterator<String> iterator = featureNames.iterator();
        while (iterator.hasNext()) {
            ContinuousFeature feature;
            DataField dataField;
            String featureName;
            String name = featureName = iterator.next();
            String value = null;
            int index = featureName.indexOf(separator);
            if (index > -1) {
                name = featureName.substring(0, index);
                value = featureName.substring(index + separator.length());
            }
            if ((dataField = encoder.getDataField(name)) == null) {
                dataField = value != null ? encoder.createDataField(name, OpType.CATEGORICAL, DataType.STRING) : encoder.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
            }
            if (value != null) {
                PMMLUtil.addValues((Field)dataField, Collections.singletonList(value));
                feature = new BinaryFeature((PMMLEncoder)encoder, (Field)dataField, (Object)value);
            } else {
                feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)dataField);
            }
            featureArray[vocabulary.get((Object)featureName).intValue()] = feature;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        result.addAll(Arrays.asList(featureArray));
        return result;
    }

    public List<String> getFeatureNames() {
        return this.getList("feature_names_", String.class);
    }

    public String getSeparator() {
        return this.getString("separator");
    }

    public Map<String, Integer> getVocabulary() {
        return (Map)this.get("vocabulary_", Map.class);
    }
}

