/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.python.CastFunction;
import org.jpmml.python.CastUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Composite;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasPMMLOptions;
import sklearn.Initializer;
import sklearn.PassThrough;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class SkLearnPipeline
extends Composite
implements HasPMMLOptions<SkLearnPipeline>,
Encodable {
    public SkLearnPipeline() {
        this("sklearn.pipeline", "Pipeline");
    }

    public SkLearnPipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean hasTransformers() {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            return false;
        }
        if (steps.size() == 1) {
            return !this.hasFinalEstimator();
        }
        return true;
    }

    @Override
    public boolean hasFinalEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            return false;
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement((Object[])finalStep, (int)1);
        if ("passthrough".equals(estimator)) {
            return true;
        }
        estimator = CastUtil.deepCastTo((Object)estimator, Estimator.class);
        return Estimator.class.isInstance(estimator);
    }

    @Override
    public List<? extends Transformer> getTransformers() {
        List<Object[]> steps = this.getSteps();
        if (this.hasFinalEstimator()) {
            steps = steps.subList(0, steps.size() - 1);
        }
        List transformers = TupleUtil.extractElementList(steps, (int)1);
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            public Transformer apply(Object object) {
                if (object == null || "passthrough".equals(object)) {
                    return PassThrough.INSTANCE;
                }
                return (Transformer)super.apply(object);
            }

            public String formatMessage(Object object) {
                return "The transformer object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        return Lists.transform((List)transformers, (Function)castFunction);
    }

    @Override
    public Estimator getFinalEstimator() {
        return this.getFinalEstimator(Estimator.class);
    }

    @Override
    public <E extends Estimator> E getFinalEstimator(Class<? extends E> clazz) {
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("Expected one or more steps, got zero steps");
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement((Object[])finalStep, (int)1);
        CastFunction castFunction = new CastFunction<E>(clazz){

            public E apply(Object object) {
                if ("passthrough".equals(object)) {
                    return null;
                }
                return (Estimator)super.apply(object);
            }

            public String formatMessage(Object object) {
                return "The transformer object of the final step (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Estimator";
            }
        };
        return (E)((Estimator)castFunction.apply(estimator));
    }

    @Override
    public Transformer getHead() {
        if (this.hasTransformers()) {
            List<? extends Transformer> transformers = this.getTransformers();
            Transformer transformer = transformers.get(0);
            return TransformerUtil.getHead(transformer);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return EstimatorUtil.getHead(estimator);
        }
        return null;
    }

    @Override
    public PMML encodePMML() {
        SkLearnEncoder encoder = new SkLearnEncoder();
        Estimator estimator = null;
        if (this.hasFinalEstimator()) {
            estimator = this.getFinalEstimator();
        }
        this.initLabel(estimator, null, encoder);
        this.initFeatures(estimator, null, encoder);
        if (estimator == null) {
            return encoder.encodePMML(null);
        }
        Schema schema = encoder.createSchema();
        Model model = estimator.encode(schema);
        encoder.setModel(model);
        return encoder.encodePMML(model);
    }

    protected List<String> initLabel(Estimator estimator, List<String> targetFields, SkLearnEncoder encoder) {
        if (estimator != null && estimator.isSupervised()) {
            if (targetFields == null) {
                targetFields = this.initTargetFields(estimator);
            }
            encoder.initLabel(estimator, targetFields);
        }
        return targetFields;
    }

    protected List<String> initTargetFields(Estimator estimator) {
        return EstimatorUtil.generateOutputNames(estimator);
    }

    protected List<String> initFeatures(Estimator estimator, List<String> activeFields, SkLearnEncoder encoder) {
        Step featureInitializer = estimator;
        try {
            Transformer transformer = this.getHead();
            if (transformer != null) {
                featureInitializer = transformer;
                if (!(transformer instanceof Initializer)) {
                    if (activeFields == null) {
                        activeFields = this.initActiveFields(transformer);
                    }
                    encoder.initFeatures(transformer, activeFields);
                }
                List<Feature> features = new ArrayList<Feature>();
                features.addAll(encoder.getFeatures());
                features = super.encodeFeatures(features, encoder);
                encoder.setFeatures(features);
            } else if (estimator != null) {
                if (activeFields == null) {
                    activeFields = this.initActiveFields(estimator);
                }
                encoder.initFeatures(estimator, activeFields);
            }
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("The transformer object of the first step (" + ClassDictUtil.formatClass((Object)featureInitializer) + ") does not specify feature type information", uoe);
        }
        return activeFields;
    }

    protected List<String> initActiveFields(Step step) {
        return StepUtil.getOrGenerateFeatureNames(step);
    }

    @Override
    public Map<String, ?> getPMMLOptions() {
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getPMMLOptions();
        }
        return null;
    }

    @Override
    public SkLearnPipeline setPMMLOptions(Map<String, ?> pmmlOptions) {
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            estimator.setPMMLOptions((Map)pmmlOptions);
        }
        return this;
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }

    protected SkLearnPipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }
}

