/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.SkLearnTransformer;
import sklearn.preprocessing.StandardScaler;

public class PowerTransformer
extends SkLearnTransformer {
    public PowerTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> lambdas = this.getLambdas();
        String method = this.getMethod();
        Boolean standardize = this.getStandardize();
        switch (method) {
            case "box-cox": {
                break;
            }
            default: {
                throw new IllegalArgumentException(method);
            }
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, lambdas});
        List<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number lambda = lambdas.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply apply = !ValueUtil.isZero((Number)lambda) ? PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{continuousFeature.ref(), PMMLUtil.createConstant((Number)lambda)}), PMMLUtil.createConstant((Number)1.0)}), PMMLUtil.createConstant((Number)lambda)}) : PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{continuousFeature.ref()});
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("boxCox", continuousFeature.getName()), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        if (standardize.booleanValue()) {
            StandardScaler scaler = this.getScaler();
            result = scaler.encode(result, encoder);
        }
        return result;
    }

    public List<? extends Number> getLambdas() {
        return this.getArray("lambdas_", Number.class);
    }

    public String getMethod() {
        return this.getString("method");
    }

    public StandardScaler getScaler() {
        return (StandardScaler)this.get("_scaler", StandardScaler.class);
    }

    public Boolean getStandardize() {
        return this.getBoolean("standardize");
    }
}

