/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.StringFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class SubstringTransformer
extends Transformer {
    public SubstringTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Integer begin = this.getBegin();
        Integer end = this.getEnd();
        if (begin < 0 || end < begin) {
            throw new IllegalArgumentException();
        }
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        if (feature.getDataType() != DataType.STRING) {
            throw new IllegalArgumentException();
        }
        Apply apply = PMMLUtil.createApply((String)"substring", (Expression[])new Expression[]{feature.ref(), PMMLUtil.createConstant((Object)(begin + 1), (DataType)DataType.INTEGER), PMMLUtil.createConstant((Object)(end - begin), (DataType)DataType.INTEGER)});
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("substring", feature), OpType.CATEGORICAL, DataType.STRING, (Expression)apply);
        return Collections.singletonList(new StringFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public Integer getBegin() {
        return this.getInteger("begin");
    }

    public Integer getEnd() {
        return this.getInteger("end");
    }
}

