/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.Scope;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn2pmml.util.EvaluatableUtil;

public class SelectFirstTransformer
extends Transformer {
    public SelectFirstTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Transformer controller = this.getController();
        List<Object[]> steps = this.getSteps();
        if (steps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = (Feature)Iterables.getOnlyElement(features);
        List<Feature> controlFeatures = features;
        if (controller != null) {
            controlFeatures = controller.encode(controlFeatures, encoder);
        }
        DataFrameScope scope = new DataFrameScope("X", controlFeatures);
        Apply apply = null;
        Apply prevIfApply = null;
        EnumSet<DataType> dataTypes = EnumSet.noneOf(DataType.class);
        for (int i = 0; i < steps.size(); ++i) {
            Object[] step = steps.get(i);
            String name = (String)TupleUtil.extractElement((Object[])step, (int)0, String.class);
            Transformer transformer = (Transformer)TupleUtil.extractElement((Object[])step, (int)1, Transformer.class);
            Object expr = TupleUtil.extractElement((Object[])step, (int)2, Object.class);
            Apply ifApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{EvaluatableUtil.translateExpression(expr, (Scope)scope)});
            List<Feature> stepFeatures = transformer.encode(Collections.singletonList(feature), encoder);
            ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{stepFeatures});
            Feature stepFeature = (Feature)Iterables.getOnlyElement(stepFeatures);
            ifApply.addExpressions(new Expression[]{stepFeature.ref()});
            dataTypes.add(stepFeature.getDataType());
            if (apply == null) {
                apply = ifApply;
            }
            if (prevIfApply != null) {
                prevIfApply.addExpressions(new Expression[]{ifApply});
            }
            prevIfApply = ifApply;
        }
        DataType dataType = (DataType)Iterables.getOnlyElement(dataTypes);
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("selectFirst", feature), opType, dataType, (Expression)apply);
        return Collections.singletonList(FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder));
    }

    public Transformer getController() {
        return (Transformer)this.getOptional("controller", Transformer.class);
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }
}

