/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.python.SliceUtil;
import sklearn.SkLearnClassifier;
import sklearn.neighbors.HasMetric;
import sklearn.neighbors.HasNumberOfNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class NearestCentroid
extends SkLearnClassifier
implements HasMetric,
HasNumberOfNeighbors,
HasTrainingData {
    public NearestCentroid(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCentroidsShape();
        return shape[1];
    }

    @Override
    public int getNumberOfOutputs() {
        return 1;
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public boolean hasProbabilityDistribution() {
        return false;
    }

    @Override
    public Model encodeModel(Schema schema) {
        int[] shape = this.getCentroidsShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLASSIFICATION, numberOfInstances, numberOfFeatures, schema).setCategoricalScoringMethod(NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE);
        return nearestNeighborModel;
    }

    public List<? extends Number> getCentroids() {
        return this.getNumberArray("centroids_");
    }

    public int[] getCentroidsShape() {
        return this.getArrayShape("centroids_", 2);
    }

    @Override
    public String getMetric() {
        return this.getString("metric");
    }

    @Override
    public int getP() {
        if (!this.containsKey("p")) {
            return -1;
        }
        return this.getInteger("p");
    }

    @Override
    public int getNumberOfNeighbors() {
        return 1;
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getCentroids();
    }

    @Override
    public int[] getFitXShape() {
        return this.getCentroidsShape();
    }

    @Override
    public List<?> getId() {
        return null;
    }

    @Override
    public List<? extends Number> getY() {
        List<?> classes = this.getClasses();
        return SliceUtil.indices((int)0, (int)classes.size());
    }

    @Override
    public int[] getYShape() {
        List<?> classes = this.getClasses();
        return new int[]{classes.size()};
    }
}

