/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.util;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.jpmml.python.ExpressionTranslator;
import org.jpmml.python.PredicateTranslator;
import org.jpmml.python.Scope;
import sklearn2pmml.util.Evaluatable;
import sklearn2pmml.util.Expression;
import sklearn2pmml.util.Predicate;

public class EvaluatableUtil {
    private EvaluatableUtil() {
    }

    public static String toString(Object expr) {
        if (expr instanceof Evaluatable) {
            Evaluatable evaluatable = (Evaluatable)((Object)expr);
            return evaluatable.getExpr();
        }
        return (String)expr;
    }

    public static org.dmg.pmml.Expression translateExpression(Object expr, Scope scope) {
        if (expr instanceof Expression) {
            Expression expression = (Expression)((Object)expr);
            return expression.translate(scope);
        }
        return EvaluatableUtil.translateExpression((String)expr, Collections.emptyList(), scope);
    }

    public static org.dmg.pmml.Expression translateExpression(String expr, List<String> functionDefs, Scope scope) {
        ExpressionTranslator expressionTranslator = new ExpressionTranslator(scope);
        for (String functionDef : functionDefs) {
            expressionTranslator.addFunctionDef(functionDef);
        }
        if (expr.indexOf(10) > -1) {
            DerivedField derivedField = expressionTranslator.translateDef(expr);
            return new FieldRef((Field)derivedField);
        }
        return expressionTranslator.translateExpression(expr);
    }

    public static org.dmg.pmml.Predicate translatePredicate(Object expr, Scope scope) {
        if (expr instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)expr);
            return predicate.translate(scope);
        }
        return EvaluatableUtil.translatePredicate((String)expr, Collections.emptyList(), scope);
    }

    public static org.dmg.pmml.Predicate translatePredicate(String expr, List<String> functionDefs, Scope scope) {
        PredicateTranslator predicateTranslator = new PredicateTranslator(scope);
        for (String functionDef : functionDefs) {
            predicateTranslator.addFunctionDef(functionDef);
        }
        return predicateTranslator.translatePredicate(expr);
    }
}

