/*
 * Decompiled with CFR 0.152.
 */
package sklearn.isotonic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Calibrator;

public class IsotonicRegression
extends Calibrator {
    public IsotonicRegression(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> xThresholds = this.getXThresholds();
        List<? extends Number> yThresholds = this.getYThresholds();
        String outOfBounds = this.getOutOfBounds();
        ClassDictUtil.checkSize((Collection[])new Collection[]{xThresholds, yThresholds});
        SchemaUtil.checkSize((int)1, features);
        Feature feature = features.get(0);
        OutlierTreatmentMethod outlierTreatment = IsotonicRegression.parseOutlierTreatment(outOfBounds);
        NormContinuous normContinuous = new NormContinuous(feature.getName(), null).setOutliers(outlierTreatment);
        for (int i = 0; i < xThresholds.size(); ++i) {
            Number orig = xThresholds.get(i);
            Number norm = yThresholds.get(i);
            normContinuous.addLinearNorms(new LinearNorm[]{new LinearNorm(orig, norm)});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("isotonicRegression", feature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)normContinuous);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public Boolean getIncreasing() {
        return this.getBoolean("increasing_");
    }

    public List<? extends Number> getXThresholds() {
        if (this.containsKey("_necessary_X_")) {
            return this.getNumberArray("_necessary_X_");
        }
        return this.getNumberArray("X_thresholds_");
    }

    public List<? extends Number> getYThresholds() {
        if (this.containsKey("_necessary_y_")) {
            this.getNumberArray("_necessary_y_");
        }
        return this.getNumberArray("y_thresholds_");
    }

    public String getOutOfBounds() {
        return this.getString("out_of_bounds");
    }

    public static OutlierTreatmentMethod parseOutlierTreatment(String outOfBounds) {
        switch (outOfBounds) {
            case "nan": {
                return OutlierTreatmentMethod.AS_MISSING_VALUES;
            }
            case "clip": {
                return OutlierTreatmentMethod.AS_EXTREME_VALUES;
            }
        }
        throw new IllegalArgumentException(outOfBounds);
    }
}

