/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.bagging;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Estimator;

public class BaggingUtil {
    private BaggingUtil() {
    }

    public static <E extends Estimator> MiningModel encodeBagging(List<E> estimators, List<List<Integer>> estimatorsFeatures, Segmentation.MultipleModelMethod multipleModelMethod, MiningFunction miningFunction, Schema schema) {
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<Model> models = new ArrayList<Model>();
        for (int i = 0; i < estimators.size(); ++i) {
            Estimator estimator = (Estimator)estimators.get(i);
            List<Integer> estimatorFeatures = estimatorsFeatures.get(i);
            Schema estimatorSchema = segmentSchema.toSubSchema(Ints.toArray(estimatorFeatures));
            Model model = estimator.encode(estimatorSchema);
            models.add(model);
        }
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, models));
        return miningModel;
    }
}

