/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.Scaler;

public class MaxAbsScaler
extends Scaler {
    public MaxAbsScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getScaleShape();
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> scale = this.getScale();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, scale});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number value = scale.get(i);
            if (ValueUtil.isOne((Number)value)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply apply = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)value)});
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("maxAbsScaler", continuousFeature), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public List<? extends Number> getScale() {
        return this.getNumberArray("scale_");
    }

    public int[] getScaleShape() {
        return this.getArrayShape("scale_", 1);
    }
}

