/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.CategoricalDtype;
import sklearn2pmml.decoration.Domain;

public abstract class DiscreteDomain
extends Domain {
    public DiscreteDomain(String module, String name) {
        super(module, name);
    }

    public abstract Feature encodeFeature(WildcardFeature var1, List<?> var2);

    @Override
    public DataType getDataType() {
        TypeInfo dtype = this.getDType();
        Boolean withData = this.getWithData();
        if (dtype != null) {
            return dtype.getDataType();
        }
        if (withData.booleanValue()) {
            List<List<?>> dataValues = this.getDataValues();
            return TypeUtil.getDataType((Collection)dataValues.get(0), (DataType)DataType.STRING);
        }
        return DataType.STRING;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        features = super.encodeFeatures(features, encoder);
        TypeInfo dtype = this.getDType();
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        List<List<?>> dataValues = null;
        if (withData.booleanValue()) {
            dataValues = this.getDataValues();
            ClassDictUtil.checkSize((int)features.size(), (Collection[])new Collection[]{dataValues});
        }
        Map<String, ?> counts = null;
        List<Object[]> discrStats = null;
        if (withStatistics.booleanValue()) {
            counts = this.getCounts();
            discrStats = this.getDiscrStats();
            ClassDictUtil.checkSize((int)features.size(), (Collection[])new Collection[]{discrStats});
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            WildcardFeature wildcardFeature = DiscreteDomain.asWildcardFeature(feature);
            List values = Collections.emptyList();
            if (withData.booleanValue()) {
                values = dataValues.get(i);
            } else if (dtype instanceof CategoricalDtype) {
                CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
                values = categoricalDtype.getValues();
            }
            feature = this.encodeFeature(wildcardFeature, values);
            if (withStatistics.booleanValue()) {
                UnivariateStats univariateStats = new UnivariateStats().setField(wildcardFeature.getName()).setCounts(DiscreteDomain.createCounts(DiscreteDomain.extractMap(counts, i))).setDiscrStats(DiscreteDomain.createDiscrStats(wildcardFeature.getDataType(), discrStats.get(i)));
                encoder.addUnivariateStats(univariateStats);
            }
            result.add(feature);
        }
        return result;
    }

    public List<? extends List<?>> getDataValues() {
        if (this.containsKey("data_values_")) {
            Object dataValues = this.get("data_values_");
            if (dataValues instanceof List) {
                List arrays = this.getList("data_values_", HasArray.class);
                Function function = new Function<HasArray, List<?>>(){

                    public List<?> apply(HasArray hasArray) {
                        return hasArray.getArrayContent();
                    }
                };
                return Lists.transform((List)arrays, (Function)function);
            }
            return Collections.singletonList(this.getArray("data_values_"));
        }
        return Collections.singletonList(this.getArray("data_"));
    }

    public List<Object[]> getDiscrStats() {
        Object discrStats = this.get("discr_stats_");
        if (discrStats instanceof List) {
            return this.getTupleList("discr_stats_");
        }
        return Collections.singletonList(this.getTuple("discr_stats_"));
    }

    public static DiscrStats createDiscrStats(DataType dataType, Object[] objects) {
        List<?> values = DiscreteDomain.asArray(objects[0]);
        List counts = ValueUtil.asIntegers(DiscreteDomain.asArray(objects[1]));
        ClassDictUtil.checkSize((Collection[])new Collection[]{values, counts});
        DiscrStats discrStats = new DiscrStats().addArrays(new Array[]{PMMLUtil.createStringArray(DiscreteDomain.standardizeValues(dataType, values)), PMMLUtil.createIntArray((List)counts)});
        return discrStats;
    }
}

