/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import com.google.common.base.CaseFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.CalendarUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public abstract class DurationTransformer
extends Transformer {
    public DurationTransformer(String module, String name) {
        super(module, name);
    }

    public abstract String getPMMLFunction();

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        GregorianCalendar epoch = this.getEpoch();
        String pmmlFunction = this.getPMMLFunction();
        LocalDateTime epochDateTime = CalendarUtil.toLocalDateTime((Calendar)epoch);
        if (epochDateTime.getMonthValue() != 1 || epochDateTime.getDayOfMonth() != 1) {
            throw new IllegalArgumentException(String.valueOf(epochDateTime));
        }
        int year = epochDateTime.getYear();
        String function = pmmlFunction;
        if (function.startsWith("date")) {
            function = function.substring("date".length());
            function = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, function);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            ObjectFeature objectFeature = (ObjectFeature)features.get(i);
            DerivedField derivedField = encoder.ensureDerivedField(this.createFieldName(function, objectFeature, year), OpType.CONTINUOUS, DataType.INTEGER, () -> ExpressionUtil.createApply((String)pmmlFunction, (Expression[])new Expression[]{objectFeature.ref(), ExpressionUtil.createConstant((DataType)DataType.INTEGER, (Object)year)}));
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public GregorianCalendar getEpoch() {
        return (GregorianCalendar)this.get("epoch", GregorianCalendar.class);
    }
}

