/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import sklearn.SkLearnRegressor;
import sklearn.neighbors.HasMetric;
import sklearn.neighbors.HasNumberOfNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsRegressor
extends SkLearnRegressor
implements HasMetric,
HasNumberOfNeighbors,
HasTrainingData {
    public KNeighborsRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public int getNumberOfOutputs() {
        return KNeighborsUtil.getNumberOfOutputs(this);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        boolean weighted;
        int[] shape = this.getFitXShape();
        String weights = this.getWeights();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        switch (weights) {
            case "distance": {
                weighted = true;
                break;
            }
            case "uniform": {
                weighted = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(weights);
            }
        }
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.REGRESSION, numberOfInstances, numberOfFeatures, schema).setContinuousScoringMethod(weighted ? NearestNeighborModel.ContinuousScoringMethod.WEIGHTED_AVERAGE : NearestNeighborModel.ContinuousScoringMethod.AVERAGE).setThreshold((Number)(weighted ? Double.valueOf(0.0) : null));
        return nearestNeighborModel;
    }

    @Override
    public String getMetric() {
        return this.getString("metric");
    }

    @Override
    public int getP() {
        return this.getInteger("p");
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.getInteger("n_neighbors");
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getNumberArray("_fit_X");
    }

    @Override
    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    @Override
    public List<?> getId() {
        if (!this.containsKey("_id")) {
            return null;
        }
        return this.getArray("_id");
    }

    @Override
    public List<? extends Number> getY() {
        return this.getNumberArray("_y");
    }

    @Override
    public int[] getYShape() {
        return this.getArrayShape("_y");
    }

    public String getWeights() {
        return this.getString("weights");
    }
}

