/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasClasses;
import sklearn.HasEstimator;
import sklearn.tree.HasTreeOptions;

public class Link
extends Estimator
implements HasClasses,
HasEstimator<Estimator> {
    public Link(String module, String name) {
        super(module, name);
    }

    @Override
    public MiningFunction getMiningFunction() {
        Estimator estimator = this.getEstimator();
        return estimator.getMiningFunction();
    }

    @Override
    public boolean isSupervised() {
        Estimator estimator = this.getEstimator();
        return estimator.isSupervised();
    }

    @Override
    public List<?> getClasses() {
        Estimator estimator = this.getEstimator();
        return EstimatorUtil.getClasses(estimator);
    }

    @Override
    public boolean hasProbabilityDistribution() {
        Estimator estimator = this.getEstimator();
        return EstimatorUtil.hasProbabilityDistribution(estimator);
    }

    @Override
    public String getAlgorithmName() {
        Estimator estimator = this.getEstimator();
        return estimator.getAlgorithmName();
    }

    @Override
    public Label encodeLabel(List<String> names, SkLearnEncoder encoder) {
        Estimator estimator = this.getEstimator();
        return estimator.encodeLabel(names, encoder);
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<String> augmentFuncs = this.getAugmentFuncs();
        Estimator estimator = this.getEstimator();
        Iterator<String> iterator = augmentFuncs.iterator();
        while (iterator.hasNext()) {
            String augmentFunc;
            switch (augmentFunc = iterator.next()) {
                case "apply": {
                    if (!(estimator instanceof HasTreeOptions)) break;
                    HasTreeOptions hasTreeOptions = (HasTreeOptions)((Object)estimator);
                    estimator.putOption("winner_id", Boolean.TRUE);
                    break;
                }
            }
        }
        return estimator.encodeModel(schema);
    }

    public Schema augmentSchema(Model model, Schema schema) {
        List<String> augmentFuncs = this.getAugmentFuncs();
        Estimator estimator = this.getEstimator();
        if (augmentFuncs.isEmpty()) {
            return schema;
        }
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        ArrayList<Feature> augmentedFeatures = new ArrayList<Feature>(features);
        for (String augmentFunc : augmentFuncs) {
            augmentedFeatures.addAll(EstimatorUtil.export(estimator, augmentFunc, schema, model, encoder));
        }
        return new Schema((PMMLEncoder)encoder, label, augmentedFeatures);
    }

    public List<String> getAugmentFuncs() {
        return this.getList("augment_funcs", String.class);
    }

    @Override
    public Estimator getEstimator() {
        return (Estimator)this.get("estimator_", Estimator.class);
    }
}

