/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.CategoricalDtypeUtil;
import pandas.core.CategoricalDtype;
import sklearn.Transformer;

public class SeriesConstructor
extends Transformer {
    public SeriesConstructor(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        TypeInfo dtype = this.getDType();
        String name = this.getName();
        DataType dataType = dtype.getDataType();
        SchemaUtil.checkSize((int)1, features);
        Feature feature = features.get(0);
        if (feature.getDataType() != dataType) {
            throw new IllegalArgumentException();
        }
        if (dtype instanceof CategoricalDtype) {
            CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
            feature = CategoricalDtypeUtil.refineFeature(feature, categoricalDtype, encoder);
        }
        if (name != null && !feature.getName().equals(name)) {
            encoder.renameFeature(feature, name);
        }
        return Collections.singletonList(feature);
    }

    public TypeInfo getDType() {
        return this.getDType("dtype", true);
    }

    public String getName() {
        return this.getOptionalString("name");
    }
}

