/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.HasArray;
import sklearn.SkLearnTransformer;
import sklearn.preprocessing.EncoderUtil;

public abstract class BaseEncoder
extends SkLearnTransformer {
    public BaseEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<List<?>> categories = this.getCategories();
        DataType result = null;
        for (int i = 0; i < categories.size(); ++i) {
            List<Object> featureCategories = categories.get(i);
            featureCategories = featureCategories.stream().filter(category -> !EncoderUtil.isMissingCategory(category)).collect(Collectors.toList());
            DataType dataType = TypeUtil.getDataType(featureCategories, null);
            if (result == null) {
                result = dataType;
                continue;
            }
            if (result == dataType) continue;
            throw new UnsupportedOperationException();
        }
        if (result == null) {
            result = DataType.STRING;
        }
        return result;
    }

    public List<List<?>> getCategories() {
        return this.getArrayList("categories_");
    }

    public String getHandleUnknown() {
        return this.getOptionalString("handle_unknown");
    }

    List<List<?>> getArrayList(String name) {
        List encodings = this.getList(name, HasArray.class);
        Function function = new Function<HasArray, List<?>>(){

            public List<?> apply(HasArray hasArray) {
                return hasArray.getArrayContent();
            }
        };
        return Lists.transform((List)encodings, (Function)function);
    }
}

