/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.BaseEncoder;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends BaseEncoder {
    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<List<?>> categories = this.getCategories();
        TypeInfo dtype = this.getDType();
        String handleUnknown = this.getHandleUnknown();
        Number unknownValue = null;
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, features});
        if (handleUnknown != null) {
            switch (handleUnknown) {
                case "error": {
                    break;
                }
                case "use_encoded_value": {
                    unknownValue = this.getUnknownValue();
                    if (!ValueUtil.isNaN((Object)unknownValue)) break;
                    unknownValue = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(handleUnknown);
                }
            }
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        DataType dataType = dtype.getDataType();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            List<?> featureCategories = categories.get(i);
            if (handleUnknown != null) {
                InvalidValueTreatmentMethod invalidValueTreatmentMethod;
                switch (handleUnknown) {
                    case "error": {
                        invalidValueTreatmentMethod = InvalidValueTreatmentMethod.RETURN_INVALID;
                        break;
                    }
                    case "use_encoded_value": {
                        invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_IS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(handleUnknown);
                    }
                }
                EncoderUtil.addDecorator(feature, (Decorator)new InvalidValueDecorator(invalidValueTreatmentMethod, null));
            }
            result.add(EncoderUtil.encodeIndexFeature(this, feature, featureCategories, null, unknownValue, dataType, encoder));
        }
        return result;
    }

    public TypeInfo getDType() {
        return this.getDType("dtype", false);
    }

    public Number getUnknownValue() {
        return this.getNumber("unknown_value");
    }
}

