/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import scipy.interpolate.BSpline;
import scipy.interpolate.BSplineUtil;
import sklearn.SkLearnTransformer;

public class SplineTransformer
extends SkLearnTransformer {
    public SplineTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<BSpline> bsplines = this.getBSplines();
        String extrapolation = this.getExtrapolation();
        Boolean includeBias = this.getIncludeBias();
        switch (extrapolation) {
            case "error": {
                break;
            }
            default: {
                throw new IllegalArgumentException(extrapolation);
            }
        }
        if (!includeBias.booleanValue()) {
            throw new IllegalArgumentException();
        }
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        BSpline bspline = bsplines.get(0);
        List<DefineFunction> splineFunctions = BSplineUtil.createSplineFunction(bspline, encoder);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < splineFunctions.size(); ++i) {
            DefineFunction splineFunction = splineFunctions.get(i);
            Apply apply = ExpressionUtil.createApply((DefineFunction)splineFunction, (Expression[])new Expression[]{continuousFeature.ref()});
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("bspline", continuousFeature, i), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public List<BSpline> getBSplines() {
        return this.getList("bsplines_", BSpline.class);
    }

    public String getExtrapolation() {
        return this.getString("extrapolation");
    }

    public Boolean getIncludeBias() {
        return this.getBoolean("include_bias");
    }
}

