/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.BaseEncoder;

public class TargetEncoder
extends BaseEncoder {
    public TargetEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String targetType;
        List<List<?>> categories = this.getCategories();
        List<List<?>> encodings = this.getEncodings();
        Number targetMean = this.getTargetMean();
        switch (targetType = this.getTargetType()) {
            case "continuous": 
            case "binary": {
                break;
            }
            default: {
                throw new IllegalArgumentException(targetType);
            }
        }
        ClassDictUtil.checkSize((int)features.size(), (Collection[])new Collection[]{categories, encodings});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            List<?> featureCategories = categories.get(i);
            List<?> featureEncodings = encodings.get(i);
            ClassDictUtil.checkSize((Collection[])new Collection[]{featureCategories, featureEncodings});
            Object missingCategory = TargetEncoder.getMissingCategory(featureCategories);
            Number mapMissingTo = null;
            int index = featureCategories.indexOf(missingCategory);
            if (index > -1) {
                featureCategories = new ArrayList(featureCategories);
                featureCategories.remove(index);
                featureEncodings = new ArrayList(featureEncodings);
                mapMissingTo = (Number)featureEncodings.remove(index);
            }
            encoder.toCategorical(feature.getName(), featureCategories);
            MapValues mapValues = ExpressionUtil.createMapValues((String)feature.getName(), featureCategories, featureEncodings).setMapMissingTo(mapMissingTo).setDefaultValue((Object)targetMean);
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("targetEncoder", feature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)mapValues);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public List<List<?>> getEncodings() {
        return this.getArrayList("encodings_");
    }

    public Number getTargetMean() {
        return this.getNumber("target_mean_");
    }

    public String getTargetType() {
        return this.getString("target_type_");
    }

    private static Object getMissingCategory(List<?> categories) {
        for (Object category : categories) {
            if (!ValueUtil.isNaN(category)) continue;
            return category;
        }
        return null;
    }
}

