/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.converter.CMatrix;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.Schema;
import org.jpmml.converter.support_vector_machine.LibSVMUtil;
import sklearn.SkLearnRegressor;
import sklearn.svm.SupportVectorMachineUtil;

public class LibSVMRegressor
extends SkLearnRegressor {
    public LibSVMRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<? extends Number> supportVectors = this.getSupportVectors();
        List<? extends Number> dualCoef = this.getDualCoef();
        List<? extends Number> intercept = this.getIntercept();
        Kernel kernel = SupportVectorMachineUtil.createKernel(this.getKernel(), this.getDegree(), this.getGamma(), this.getCoef0());
        return LibSVMUtil.createRegression((Kernel)kernel, (Matrix)new CMatrix(supportVectors, numberOfVectors, numberOfFeatures), SupportVectorMachineUtil.formatIds(support), (Number)((Number)Iterables.getOnlyElement(intercept)), dualCoef, (Schema)schema);
    }

    public String getKernel() {
        return this.getString("kernel");
    }

    public Integer getDegree() {
        return this.getInteger("degree");
    }

    public Number getGamma() {
        return this.getNumber("_gamma");
    }

    public Number getCoef0() {
        return this.getNumber("coef0");
    }

    public List<Integer> getSupport() {
        return this.getIntegerArray("support_");
    }

    public List<? extends Number> getSupportVectors() {
        return this.getNumberArray("support_vectors_");
    }

    public int[] getSupportVectorsShape() {
        return this.getArrayShape("support_vectors_", 2);
    }

    public List<? extends Number> getDualCoef() {
        return this.getNumberArray("_dual_coef_");
    }

    public List<? extends Number> getIntercept() {
        return this.getNumberArray("_intercept_");
    }
}

