/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class Aggregator
extends Transformer {
    public Aggregator(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return -1;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String function = this.getFunction();
        if (features.size() <= 1) {
            return features;
        }
        Apply apply = ExpressionUtil.createApply((String)Aggregator.translateFunction(function), (Expression[])new Expression[0]);
        for (Feature feature : features) {
            apply.addExpressions(new Expression[]{feature.ref()});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName(function, features), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public String getFunction() {
        return this.getString("function");
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "max": {
                return "max";
            }
            case "mean": 
            case "avg": {
                return "avg";
            }
            case "min": {
                return "min";
            }
            case "prod": 
            case "product": {
                return "product";
            }
            case "sum": {
                return "sum";
            }
        }
        throw new IllegalArgumentException(function);
    }
}

