/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class LookupTransformer
extends Transformer {
    public LookupTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        Map<?, ?> mapping = this.getMapping();
        ArrayList inputValues = new ArrayList(mapping.keySet());
        return TypeUtil.getDataType(inputValues, (DataType)DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Map<?, ?> mapping = this.getMapping();
        Object defaultValue = this.getDefaultValue();
        List<String> columns = this.formatColumns(features);
        ClassDictUtil.checkSize((int)(features.size() + 1), (Collection[])new Collection[]{columns});
        List<String> inputColumns = columns.subList(0, columns.size() - 1);
        String outputColumn = columns.get(columns.size() - 1);
        Map<String, List<Object>> data = this.parseMapping(inputColumns, outputColumn, mapping);
        MapValues mapValues = new MapValues(outputColumn, PMMLUtil.createInlineTable(data));
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            String inputColumn = inputColumns.get(i);
            mapValues.addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), inputColumn)});
        }
        ArrayList<Object> outputValues = new ArrayList<Object>();
        outputValues.addAll((Collection)data.get(outputColumn));
        if (defaultValue != null) {
            mapValues.setDefaultValue(defaultValue);
            outputValues.add(defaultValue);
        }
        DataType dataType = TypeUtil.getDataType(outputValues, (DataType)DataType.STRING);
        mapValues.setDataType(dataType);
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("lookup", features), OpType.CATEGORICAL, dataType, (Expression)mapValues);
        return Collections.singletonList(TransformerUtil.createFeature(derivedField, encoder));
    }

    protected List<String> formatColumns(List<Feature> features) {
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        return Arrays.asList("data:input", "data:output");
    }

    protected Map<String, List<Object>> parseMapping(List<String> inputColumns, String outputColumn, Map<?, ?> mapping) {
        ArrayList inputValues = new ArrayList();
        ArrayList outputValues = new ArrayList();
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            Object inputValue = entry.getKey();
            Object outputValue = entry.getValue();
            if (inputValue == null) {
                throw new IllegalArgumentException();
            }
            if (outputValue == null) continue;
            inputValues.add(inputValue);
            outputValues.add(outputValue);
        }
        String inputColumn = inputColumns.get(0);
        LinkedHashMap<String, List<Object>> linkedHashMap = new LinkedHashMap<String, List<Object>>();
        linkedHashMap.put(inputColumn, inputValues);
        linkedHashMap.put(outputColumn, outputValues);
        return linkedHashMap;
    }

    public Map<?, ?> getMapping() {
        return (Map)this.get("mapping", Map.class);
    }

    public Object getDefaultValue() {
        return this.getOptionalScalar("default_value");
    }
}

