/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.bagging;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Schema;
import sklearn.Classifier;
import sklearn.ensemble.EnsembleClassifier;
import sklearn.ensemble.bagging.BaggingUtil;

public class BaggingClassifier
extends EnsembleClassifier {
    public BaggingClassifier(String module, String name) {
        super(module, name);
    }

    public MiningModel encodeModel(Schema schema) {
        List<Classifier> estimators = this.getEstimators();
        List<List<Number>> estimatorsFeatures = this.getEstimatorsFeatures();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        Segmentation.MultipleModelMethod multipleModelMethod = Segmentation.MultipleModelMethod.AVERAGE;
        for (Classifier estimator : estimators) {
            if (estimator.hasProbabilityDistribution()) continue;
            multipleModelMethod = Segmentation.MultipleModelMethod.MAJORITY_VOTE;
            break;
        }
        MiningModel miningModel = BaggingUtil.encodeBagging(estimators, estimatorsFeatures, multipleModelMethod, MiningFunction.CLASSIFICATION, schema);
        this.encodePredictProbaOutput((Model)miningModel, DataType.DOUBLE, (DiscreteLabel)categoricalLabel);
        return miningModel;
    }

    public List<List<Number>> getEstimatorsFeatures() {
        return this.getArrayList("estimators_features_", Number.class);
    }
}

