/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDefaultValue;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.Scope;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.CategoricalDtypeUtil;
import pandas.core.CategoricalDtype;
import sklearn.Transformer;
import sklearn2pmml.util.EvaluatableUtil;

public class ExpressionTransformer
extends Transformer {
    private static final String INVALIDVALUETREATMENT_AS_MISSING = "as_missing";
    private static final String INVALIDVALUETREATMENT_RETURN_INVALID = "return_invalid";

    public ExpressionTransformer() {
        this("sklearn2pmml.preprocessing", "ExpressionTransformer");
    }

    public ExpressionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Field field;
        FieldRef fieldRef;
        Feature feature;
        DataType dataType;
        FieldRef fieldRef2;
        Object expr = this.getExpr();
        Object mapMissingTo = this.getMapMissingTo();
        Object defaultValue = this.getDefaultValue();
        InvalidValueTreatmentMethod invalidValueTreatment = ExpressionTransformer.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        TypeInfo dtype = this.getDType();
        if (ValueUtil.isNaN((Object)defaultValue)) {
            defaultValue = null;
        }
        if (ValueUtil.isNaN((Object)mapMissingTo)) {
            mapMissingTo = null;
        }
        DataFrameScope scope = new DataFrameScope("X", features, (PMMLEncoder)encoder);
        Expression expression = EvaluatableUtil.translateExpression(expr, (Scope)scope);
        DerivedField derivedField = null;
        if (expression instanceof FieldRef && (derivedField = encoder.getDerivedField((fieldRef2 = (FieldRef)expression).requireField())) != null) {
            expression = derivedField.getExpression();
        }
        if (mapMissingTo != null) {
            HasMapMissingTo hasMapMissingTp = (HasMapMissingTo)expression;
            hasMapMissingTp.setMapMissingTo(mapMissingTo);
        }
        if (defaultValue != null) {
            HasDefaultValue hasDefaultValue = (HasDefaultValue)expression;
            hasDefaultValue.setDefaultValue(defaultValue);
        }
        if (invalidValueTreatment != null) {
            Apply apply = (Apply)expression;
            apply.setInvalidValueTreatment(invalidValueTreatment);
        }
        if (dtype != null) {
            dataType = dtype.getDataType();
        } else {
            dataType = ExpressionUtil.getDataType((Expression)expression, (FeatureResolver)scope);
            if (dataType == null) {
                dataType = DataType.DOUBLE;
            }
        }
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        if (expression instanceof FieldRef && mapMissingTo == null && (feature = scope.resolveFeature((fieldRef = (FieldRef)expression).requireField())) != null && (field = feature.getField()).requireOpType() == opType && field.requireDataType() == dataType) {
            if (dtype instanceof CategoricalDtype) {
                CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
                feature = CategoricalDtypeUtil.refineFeature(feature, categoricalDtype, encoder);
            }
            return Collections.singletonList(feature);
        }
        if (derivedField != null) {
            derivedField.setOpType(opType).setDataType(dataType);
        } else {
            derivedField = encoder.createDerivedField(this.createFieldName("eval", EvaluatableUtil.toString(expr)), opType, dataType, expression);
        }
        Feature feature2 = FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder);
        if (dtype instanceof CategoricalDtype) {
            CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
            feature2 = CategoricalDtypeUtil.refineFeature(feature2, categoricalDtype, encoder);
        }
        return Collections.singletonList(feature2);
    }

    public Object getDefaultValue() {
        return this.getOptionalScalar("default_value");
    }

    public ExpressionTransformer setDefaultValue(Object defaultValue) {
        this.setattr("default_value", defaultValue);
        return this;
    }

    public TypeInfo getDType() {
        if (this.hasattr("dtype_")) {
            return super.getOptionalDType("dtype_", true);
        }
        return super.getOptionalDType("dtype", true);
    }

    public ExpressionTransformer setDType(Object dtype) {
        this.setattr("dtype", dtype);
        return this;
    }

    public Object getExpr() {
        if (this.hasattr("expr_")) {
            return this.getString("expr_");
        }
        return this.getObject("expr");
    }

    public ExpressionTransformer setExpr(String expr) {
        this.setattr("expr", expr);
        return this;
    }

    public String getInvalidValueTreatment() {
        return (String)this.getOptionalEnum("invalid_value_treatment", arg_0 -> ((ExpressionTransformer)this).getOptionalString(arg_0), Arrays.asList(INVALIDVALUETREATMENT_AS_MISSING, INVALIDVALUETREATMENT_RETURN_INVALID));
    }

    public ExpressionTransformer setInvalidValueTreatment(String invalidValueTreatment) {
        this.setattr("invalid_value_treatment", invalidValueTreatment);
        return this;
    }

    public Object getMapMissingTo() {
        return this.getOptionalScalar("map_missing_to");
    }

    public ExpressionTransformer setMapMissingTo(Object mapMissingTo) {
        this.setattr("map_missing_to", mapMissingTo);
        return this;
    }

    private static InvalidValueTreatmentMethod parseInvalidValueTreatment(String invalidValueTreatment) {
        if (invalidValueTreatment == null) {
            return null;
        }
        switch (invalidValueTreatment) {
            case "as_missing": {
                return InvalidValueTreatmentMethod.AS_MISSING;
            }
            case "return_invalid": {
                return InvalidValueTreatmentMethod.RETURN_INVALID;
            }
        }
        throw new IllegalArgumentException(invalidValueTreatment);
    }
}

