/*
 * Decompiled with CFR 0.152.
 */
package scipy.interpolate;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import scipy.interpolate.BSpline;

public class BSplineUtil {
    private BSplineUtil() {
    }

    public static List<DefineFunction> createSplineFunction(BSpline bspline, SkLearnEncoder encoder) {
        int k = bspline.getK();
        List c = bspline.getC();
        List t = bspline.getT();
        int[] cShape = bspline.getCShape();
        int n = t.size() - k - 1;
        if (cShape.length == 1) {
            for (int i = 0; i < n; ++i) {
                for (int j = k; j >= 0; --j) {
                    BSplineUtil.createBasisFunction(t, i, j, encoder);
                }
            }
            DefineFunction splineFunction = BSplineUtil.createSplineFunction(null, c, n, k, encoder);
            return Collections.singletonList(splineFunction);
        }
        if (cShape.length == 2) {
            int rows = cShape[0];
            int columns = cShape[1];
            for (int i = 0; i < n + k; ++i) {
                for (int j = k; j >= 0; --j) {
                    BSplineUtil.createBasisFunction(t, i, j, encoder);
                }
            }
            ArrayList<DefineFunction> result = new ArrayList<DefineFunction>();
            for (int i = 0; i < rows; ++i) {
                DefineFunction splineFunction = BSplineUtil.createSplineFunction(i, CMatrixUtil.getRow((List)c, (int)rows, (int)columns, (int)i), n, k, encoder);
                result.add(splineFunction);
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    private static DefineFunction createSplineFunction(Integer row, List<Number> c, int n, int k, SkLearnEncoder encoder) {
        Expression expression;
        ParameterField valueField = new ParameterField().setName("x").setOpType(OpType.CONTINUOUS).setDataType(DataType.DOUBLE);
        ArrayList<Apply> expressions = new ArrayList<Apply>();
        for (int i = 0; i < n; ++i) {
            Number coefficient = c.get(i);
            if (ValueUtil.isZero((Number)coefficient)) continue;
            Apply apply = ExpressionUtil.createApply((String)BSplineUtil.formatBFunction(i, k), (Expression[])new Expression[]{new FieldRef((Field)valueField)});
            if (!ValueUtil.isOne((Number)coefficient)) {
                apply = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)coefficient), apply});
            }
            expressions.add(apply);
        }
        if (expressions.size() == 1) {
            expression = (Expression)Iterables.getOnlyElement(expressions);
        } else if (expressions.size() >= 2) {
            expression = ExpressionUtil.createApply((String)"sum", (Expression[])new Expression[0]).addExpressions(expressions.toArray(new Expression[expressions.size()]));
        } else {
            throw new IllegalArgumentException();
        }
        DefineFunction splineFunction = new DefineFunction(BSplineUtil.formatBSplineFunction(k) + (row != null ? "[" + row + "]" : ""), OpType.CONTINUOUS, DataType.DOUBLE, null, expression).addParameterFields(new ParameterField[]{valueField});
        encoder.addDefineFunction(splineFunction);
        return splineFunction;
    }

    private static DefineFunction createBasisFunction(List<Number> t, int i, int k, SkLearnEncoder encoder) {
        Object expression;
        ParameterField valueField = new ParameterField().setName("x").setOpType(OpType.CONTINUOUS).setDataType(DataType.DOUBLE);
        if (k == 0) {
            expression = !t.get(i).equals(t.get(i + 1)) ? ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"and", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"greaterOrEqual", (Expression[])new Expression[]{new FieldRef((Field)valueField), ExpressionUtil.createConstant((Number)t.get(i))}), ExpressionUtil.createApply((String)"lessThan", (Expression[])new Expression[]{new FieldRef((Field)valueField), ExpressionUtil.createConstant((Number)t.get(i + 1))})}), ExpressionUtil.createConstant((Number)1.0), ExpressionUtil.createConstant((Number)0.0)}) : ExpressionUtil.createConstant((Number)0.0);
        } else {
            Apply apply;
            ArrayList<Apply> expressions = new ArrayList<Apply>(2);
            if (i + k < t.size() && !t.get(i + k).equals(t.get(i))) {
                apply = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{new FieldRef((Field)valueField), ExpressionUtil.createConstant((Number)t.get(i))}), ExpressionUtil.createConstant((Number)(t.get(i + k).doubleValue() - t.get(i).doubleValue()))});
                apply = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{apply, ExpressionUtil.createApply((String)BSplineUtil.formatBFunction(i, k - 1), (Expression[])new Expression[]{new FieldRef((Field)valueField)})});
                expressions.add(apply);
            }
            if (i + k + 1 < t.size() && !t.get(i + k + 1).equals(t.get(i + 1))) {
                apply = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)t.get(i + k + 1)), new FieldRef((Field)valueField)}), ExpressionUtil.createConstant((Number)(t.get(i + k + 1).doubleValue() - t.get(i + 1).doubleValue()))});
                apply = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{apply, ExpressionUtil.createApply((String)BSplineUtil.formatBFunction(i + 1, k - 1), (Expression[])new Expression[]{new FieldRef((Field)valueField)})});
                expressions.add(apply);
            }
            expression = expressions.size() == 2 ? ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{(Expression)expressions.get(0), (Expression)expressions.get(1)}) : (expressions.size() == 1 ? (Expression)Iterables.getOnlyElement(expressions) : ExpressionUtil.createConstant((Number)0.0));
        }
        DefineFunction defineFunction = new DefineFunction(BSplineUtil.formatBFunction(i, k), OpType.CONTINUOUS, DataType.DOUBLE, null, (Expression)expression).addParameterFields(new ParameterField[]{valueField});
        encoder.addDefineFunction(defineFunction);
        return defineFunction;
    }

    private static String formatBSplineFunction(int k) {
        return FieldNameUtil.create((String)"scipy.interpolate.BSpline", (Object[])new Object[]{k});
    }

    private static String formatBFunction(int i, int k) {
        return FieldNameUtil.create((String)"scipy.interpolate.B", (Object[])new Object[]{i, k});
    }
}

