/*
 * Decompiled with CFR 0.152.
 */
package sklearn.compose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Feature;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Drop;
import sklearn.HasFeatureNamesIn;
import sklearn.HasSparseOutput;
import sklearn.Initializer;
import sklearn.InitializerUtil;
import sklearn.PassThrough;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class ColumnTransformer
extends Initializer
implements HasFeatureNamesIn,
HasSparseOutput,
Encodable {
    public ColumnTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        List<Feature> features = Collections.emptyList();
        List<String> names = this.getFeatureNamesIn();
        if (names != null) {
            features = new ArrayList();
            for (String featureNameIn : names) {
                Feature feature = InitializerUtil.createWildcardFeature(featureNameIn, encoder);
                features.add(feature);
            }
        }
        return this.encodeFeatures(features, encoder);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Object[]> fittedTransformers = this.getFittedTransformers();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Object[] fittedTransformer : fittedTransformers) {
            Transformer transformer = ColumnTransformer.getTransformer(fittedTransformer);
            List<Feature> rowFeatures = ColumnTransformer.getFeatures(fittedTransformer, features, encoder);
            rowFeatures = transformer.encode(rowFeatures, encoder);
            result.addAll(rowFeatures);
        }
        return result;
    }

    @Override
    public PMML encodePMML() {
        return TransformerUtil.encodePMML(this);
    }

    public List<Object[]> getFittedTransformers() {
        return this.getTupleList("transformers_");
    }

    @Override
    public Boolean getSparseOutput() {
        return this.getBoolean("sparse_output_");
    }

    protected static Transformer getTransformer(Object[] fittedTransformer) {
        Object transformer = TupleUtil.extractElement((Object[])fittedTransformer, (int)1);
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            public Transformer apply(Object object) {
                if (Objects.equals("drop", object)) {
                    return Drop.INSTANCE;
                }
                if (Objects.equals("passthrough", object)) {
                    return PassThrough.INSTANCE;
                }
                return (Transformer)super.apply(object);
            }

            protected String formatMessage(Object object) {
                return "The estimator object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        return (Transformer)castFunction.apply(transformer);
    }

    protected static void setTransformer(Object[] fittedTransformer, Transformer transformer) {
        fittedTransformer[1] = transformer;
    }

    protected static List<Feature> getFeatures(Object[] fittedTransformer, List<Feature> features, SkLearnEncoder encoder) {
        List<Object> columns = TupleUtil.extractElement((Object[])fittedTransformer, (int)2);
        if (columns instanceof String || columns instanceof Integer) {
            columns = Collections.singletonList(columns);
        } else if (columns instanceof HasArray) {
            HasArray hasArray = (HasArray)columns;
            ArrayList<Object> values = new ArrayList<Object>();
            values.addAll(hasArray.getArrayContent());
            for (int i = values.size() - 1; i > -1; --i) {
                Object value = values.get(i);
                if (!(value instanceof Boolean)) continue;
                Boolean booleanValue = (Boolean)value;
                if (booleanValue.booleanValue()) {
                    values.set(i, i);
                    continue;
                }
                values.remove(i);
            }
            columns = values;
        }
        return InitializerUtil.selectFeatures(columns, features, encoder);
    }
}

