/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.preprocessing.StringTransformer;

public class StringNormalizer
extends StringTransformer {
    private static final String FUNCTION_LOWER = "lower";
    private static final String FUNCTION_LOWERCASE = "lowercase";
    private static final String FUNCTION_UPPER = "upper";
    private static final String FUNCTION_UPPERCASE = "uppercase";

    public StringNormalizer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String function = this.getFunction();
        Boolean trimBlanks = this.getTrimBlanks();
        if (function == null && !trimBlanks.booleanValue()) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Feature feature : features) {
            FieldRef expression = feature.ref();
            if (function != null) {
                expression = ExpressionUtil.createApply((String)StringNormalizer.translateFunction(function), (Expression[])new Expression[]{expression});
            }
            if (trimBlanks.booleanValue()) {
                expression = ExpressionUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{expression});
            }
            Field field = encoder.toCategorical(feature.getName(), Collections.emptyList());
            field.setDataType(DataType.STRING);
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("normalize", feature), OpType.CATEGORICAL, DataType.STRING, (Expression)expression);
            feature = new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
            result.add(feature);
        }
        return result;
    }

    public String getFunction() {
        return (String)this.getOptionalEnum("function", arg_0 -> ((StringNormalizer)this).getOptionalString(arg_0), Arrays.asList(FUNCTION_LOWER, FUNCTION_LOWERCASE, FUNCTION_UPPER, FUNCTION_UPPERCASE));
    }

    public Boolean getTrimBlanks() {
        return this.getOptionalBoolean("trim_blanks", Boolean.FALSE);
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "lower": 
            case "lowercase": {
                return FUNCTION_LOWERCASE;
            }
            case "upper": 
            case "uppercase": {
                return FUNCTION_UPPERCASE;
            }
        }
        throw new IllegalArgumentException(function);
    }
}

