/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.iforest;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.OutlierDetector;
import sklearn.Regressor;
import sklearn.VersionUtil;
import sklearn.ensemble.EnsembleRegressor;
import sklearn.ensemble.iforest.HasIsolationForest;
import sklearn.ensemble.iforest.IsolationForestUtil;
import sklearn.tree.HasTreeOptions;
import sklearn.tree.Tree;
import sklearn.tree.TreeRegressor;
import sklearn.tree.TreeUtil;

public class IsolationForest
extends EnsembleRegressor
implements HasIsolationForest,
HasTreeOptions,
OutlierDetector {
    private static final String BEHAVIOUR_DEPRECATED = "deprecated";
    private static final String BEHAVIOUR_NEW = "new";
    private static final String BEHAVIOUR_OLD = "old";

    public IsolationForest(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfOutputs() {
        return 0;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public Label encodeLabel(List<String> names, SkLearnEncoder encoder) {
        throw new UnsupportedOperationException();
    }

    public MiningModel encodeModel(Schema schema) {
        String sklearnVersion = this.getSkLearnVersion();
        List<Regressor> estimators = this.getEstimators();
        List<List<Number>> estimatorsFeatures = this.getEstimatorsFeatures();
        boolean corrected = sklearnVersion != null && VersionUtil.compareVersion(sklearnVersion, "0.19") >= 0;
        boolean nodeSampleCorrected = sklearnVersion != null && VersionUtil.compareVersion(sklearnVersion, "0.21") >= 0;
        PredicateManager predicateManager = new PredicateManager();
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (int i = 0; i < estimators.size(); ++i) {
            TreeRegressor estimator = (TreeRegressor)estimators.get(i);
            List<Number> estimatorFeatures = estimatorsFeatures.get(i);
            Schema estimatorSchema = segmentSchema.toSubSchema(Ints.toArray(estimatorFeatures));
            Tree tree = estimator.getTree();
            TreeModel treeModel = TreeUtil.encodeTreeModel(estimator, MiningFunction.REGRESSION, predicateManager, null, estimatorSchema);
            IsolationForestUtil.transformTreeModel(treeModel, tree, corrected, nodeSampleCorrected);
            ClassDictUtil.clearContent((ClassDict)tree);
            treeModels.add(treeModel);
        }
        return IsolationForestUtil.encodeMiningModel(this, treeModels, corrected, nodeSampleCorrected, schema);
    }

    @Override
    public Schema configureSchema(Schema schema) {
        return TreeUtil.configureSchema(this, schema);
    }

    @Override
    public Model configureModel(Model model) {
        return TreeUtil.configureModel(this, model);
    }

    @Override
    public Number getDecisionFunctionThreshold() {
        String behaviour = this.getBehaviour();
        if (behaviour == null) {
            return this.getThreshold();
        }
        switch (behaviour) {
            case "old": {
                return this.getThreshold();
            }
            case "deprecated": 
            case "new": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException(behaviour);
    }

    @Override
    public List<Regressor> getEstimators() {
        return this.getList("estimators_", TreeRegressor.class);
    }

    @Override
    public List<List<Number>> getEstimatorsFeatures() {
        return this.getArrayList("estimators_features_", Number.class);
    }

    public String getBehaviour() {
        return (String)this.getOptionalEnum("behaviour", arg_0 -> ((IsolationForest)this).getOptionalString(arg_0), Arrays.asList(BEHAVIOUR_DEPRECATED, BEHAVIOUR_NEW, BEHAVIOUR_OLD));
    }

    @Override
    public Integer getMaxSamples() {
        return this.getInteger("max_samples_");
    }

    @Override
    public Number getOffset() {
        if (!this.hasattr("offset_")) {
            return 0.5;
        }
        return this.getNumber("offset_");
    }

    public Number getThreshold() {
        if (this.hasattr("threshold_")) {
            return this.getNumber("threshold_");
        }
        if (this.hasattr("_threshold_")) {
            return this.getNumber("_threshold_");
        }
        return 0.0;
    }
}

