/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import sklearn.SkLearnClassifier;
import sklearn.neighbors.HasMetric;
import sklearn.neighbors.HasNumberOfNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsConstants;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsClassifier
extends SkLearnClassifier
implements HasMetric,
HasNumberOfNeighbors,
HasTrainingData,
KNeighborsConstants {
    public KNeighborsClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public int getNumberOfOutputs() {
        return KNeighborsUtil.getNumberOfOutputs(this);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public boolean hasProbabilityDistribution() {
        return false;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        String weights = this.getWeights();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        boolean weighted = KNeighborsUtil.parseWeights(weights);
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLASSIFICATION, numberOfInstances, numberOfFeatures, schema).setCategoricalScoringMethod(weighted ? NearestNeighborModel.CategoricalScoringMethod.WEIGHTED_MAJORITY_VOTE : NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE).setThreshold((Number)(weighted ? Double.valueOf(0.0) : null));
        return nearestNeighborModel;
    }

    @Override
    public String getMetric() {
        return (String)this.getEnum("metric", arg_0 -> ((KNeighborsClassifier)this).getString(arg_0), ENUM_METRIC);
    }

    @Override
    public Integer getP() {
        return this.getInteger("p");
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.getInteger("n_neighbors");
    }

    public List<Number> getFitX() {
        return this.getNumberArray("_fit_X");
    }

    @Override
    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    public List<Object> getId() {
        if (!this.hasattr("_id")) {
            return null;
        }
        return this.getObjectArray("_id");
    }

    public List<Number> getY() {
        return this.getNumberArray("_y");
    }

    @Override
    public int[] getYShape() {
        return this.getArrayShape("_y");
    }

    public String getWeights() {
        return (String)this.getEnum("weights", arg_0 -> ((KNeighborsClassifier)this).getString(arg_0), ENUM_WEIGHTS);
    }
}

