/*
 * Decompiled with CFR 0.152.
 */
package sklearn.tree;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ScoreDistributionManager;
import sklearn.Estimator;
import sklearn.HasEstimatorEnsemble;
import sklearn.tree.TreeUtil;

public class TreeEnsembleUtil {
    private TreeEnsembleUtil() {
    }

    public static <E extends Estimator, T extends Estimator> List<TreeModel> encodeTreeModelEnsemble(E estimator, final MiningFunction miningFunction, Schema schema) {
        List estimators = ((HasEstimatorEnsemble)((Object)estimator)).getEstimators();
        final Schema segmentSchema = schema.toAnonymousSchema();
        final PredicateManager predicateManager = new PredicateManager();
        final ScoreDistributionManager scoreDistributionManager = miningFunction == MiningFunction.CLASSIFICATION ? new ScoreDistributionManager() : null;
        Function function = new Function<T, TreeModel>(){

            @Override
            public TreeModel apply(T estimator) {
                TreeModel treeModel = TreeUtil.encodeTreeModel(estimator, miningFunction, predicateManager, scoreDistributionManager, segmentSchema);
                if (((Estimator)estimator).hasFeatureImportances()) {
                    Schema featureImportanceSchema = TreeUtil.toTreeModelFeatureImportanceSchema(segmentSchema);
                    ((Estimator)estimator).addFeatureImportances((Model)treeModel, featureImportanceSchema);
                }
                return treeModel;
            }
        };
        return estimators.stream().map(function).collect(Collectors.toList());
    }
}

