/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Expression;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.Scope;
import sklearn.Regressor;
import sklearn2pmml.expression.ExpressionUtil;
import sklearn2pmml.util.EvaluatableUtil;

public class ExpressionRegressor
extends Regressor {
    private static final String NORMALIZATIONMETHOD_EXP = "exp";
    private static final String NORMALIZATIONMETHOD_NONE = "none";

    public ExpressionRegressor(String module, String name) {
        super(module, name);
    }

    public RegressionModel encodeModel(Schema schema) {
        Object expr = this.getExpr();
        RegressionModel.NormalizationMethod normalizationMethod = ExpressionRegressor.parseNormalizationMethod(this.getNormalizationMethod());
        PMMLEncoder encoder = schema.getEncoder();
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        List features = schema.getFeatures();
        DataFrameScope scope = new DataFrameScope("X", features, encoder);
        Expression pmmlExpression = EvaluatableUtil.translateExpression(expr, (Scope)scope);
        ContinuousFeature exprFeature = ExpressionUtil.toFeature(FieldNameUtil.create((String)"expression", (Object[])new Object[0]), pmmlExpression, encoder);
        RegressionTable regressionTable = RegressionModelUtil.createRegressionTable(Collections.singletonList(exprFeature), Collections.singletonList(1.0), (Number)0.0);
        RegressionModel regressionModel = new RegressionModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel), null).setNormalizationMethod(normalizationMethod).addRegressionTables(new RegressionTable[]{regressionTable});
        return regressionModel;
    }

    public Object getExpr() {
        return this.getObject("expr");
    }

    public String getNormalizationMethod() {
        if (!this.hasattr("normalization_method")) {
            return NORMALIZATIONMETHOD_NONE;
        }
        return (String)this.getEnum("normalization_method", arg_0 -> ((ExpressionRegressor)this).getString(arg_0), Arrays.asList(NORMALIZATIONMETHOD_NONE, NORMALIZATIONMETHOD_EXP));
    }

    private static RegressionModel.NormalizationMethod parseNormalizationMethod(String normalizationMethod) {
        switch (normalizationMethod) {
            case "none": {
                return RegressionModel.NormalizationMethod.NONE;
            }
            case "exp": {
                return RegressionModel.NormalizationMethod.EXP;
            }
        }
        throw new IllegalArgumentException(normalizationMethod);
    }
}

