/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.SkLearnTransformer;
import sklearn.preprocessing.StandardScaler;

public class PowerTransformer
extends SkLearnTransformer {
    private static final String METHOD_BOXCOX = "box-cox";
    private static final String METHOD_YEOJOHNSON = "yeo-johnson";

    public PowerTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Number> lambdas = this.getLambdas();
        String method = this.getMethod();
        Boolean standardize = this.getStandardize();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, lambdas});
        List<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Apply apply;
            Feature feature = features.get(i);
            Number lambda = lambdas.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            switch (method) {
                case "box-cox": {
                    apply = PowerTransformer.encodeBoxCoxTransform(continuousFeature, lambda);
                    break;
                }
                case "yeo-johnson": {
                    apply = PowerTransformer.encodeYeoJohnsonTransform(continuousFeature, lambda);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("power", continuousFeature.getName()), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        if (standardize.booleanValue()) {
            StandardScaler scaler = this.getScaler();
            result = scaler.encode(result, encoder);
        }
        return result;
    }

    public List<Number> getLambdas() {
        return this.getNumberArray("lambdas_");
    }

    public String getMethod() {
        return (String)this.getEnum("method", arg_0 -> ((PowerTransformer)this).getString(arg_0), Arrays.asList(METHOD_BOXCOX, METHOD_YEOJOHNSON));
    }

    public StandardScaler getScaler() {
        return (StandardScaler)this.get("_scaler", StandardScaler.class);
    }

    public Boolean getStandardize() {
        return this.getBoolean("standardize");
    }

    private static Apply encodeBoxCoxTransform(ContinuousFeature continuousFeature, Number lambda) {
        if (!ValueUtil.isZero((Number)lambda)) {
            return ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)lambda)}), ExpressionUtil.createConstant((Number)1.0)}), ExpressionUtil.createConstant((Number)lambda)});
        }
        return ExpressionUtil.createApply((String)"ln", (Expression[])new Expression[]{continuousFeature.ref()});
    }

    private static Apply encodeYeoJohnsonTransform(ContinuousFeature continuousFeature, Number lambda) {
        Apply falseApply;
        Apply trueApply = !ValueUtil.isZero((Number)lambda) ? ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)1.0)}), ExpressionUtil.createConstant((Number)lambda)}), ExpressionUtil.createConstant((Number)1.0)}), ExpressionUtil.createConstant((Number)lambda)}) : ExpressionUtil.createApply((String)"ln1p", (Expression[])new Expression[]{continuousFeature.ref()});
        if (lambda.doubleValue() != 2.0) {
            double twoMinusLambda = 2.0 - lambda.doubleValue();
            falseApply = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)1.0), continuousFeature.ref()}), ExpressionUtil.createConstant((Number)twoMinusLambda)}), ExpressionUtil.createConstant((Number)1.0)}), ExpressionUtil.createConstant((Number)(-1.0 * twoMinusLambda))});
        } else {
            falseApply = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)-1.0), ExpressionUtil.createApply((String)"ln1p", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)-1.0), continuousFeature.ref()})})});
        }
        return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"greaterOrEqual", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)0.0)}), trueApply, falseApply});
    }
}

